% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtson.R
\name{toTSON}
\alias{toTSON}
\title{Serialize a list}
\usage{
toTSON(object)
}
\arguments{
\item{object}{A list}
}
\value{
A raw vector
}
\description{
This function convert a list into raw following TSON specification binary-encoded format.
}
\examples{
## Example

library(rtson)

list = list(integer=42L,
            double=42,
            bool=TRUE,
            uint8=tson.uint8.vec(c(42,0)),
            uint16=tson.uint16.vec(c(42,0)),
            uint32=tson.uint32.vec(c(42,0)),
            int8=tson.int8.vec(c(42,0)),
            int16=tson.int16.vec(c(42,0)),
            int32=as.integer(c(42,0)),
            float32=tson.float32.vec(c(0.0, 42.0)),
            float64=c(42.0,42.0),
            map=list(x=42, y=42, label="42"),
            list=list("42",42)
)

bytes = toTSON(list)
}

