% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrMeans.r
\name{qpcrMeans}
\alias{qpcrMeans}
\title{Fold change (\eqn{\Delta \Delta C_T} method) analysis using a model}
\usage{
qpcrMeans(model, specs, p.adj = "none")
}
\arguments{
\item{model}{an `lmer` fitted model object}

\item{specs}{A character vector specifying the names of the predictors over which FC values are desired}

\item{p.adj}{Method for adjusting p values}
}
\value{
Table of FC values, significance and confidence limits.
}
\description{
Fold change (\eqn{\Delta \Delta C_T} method) analysis using a model produced by the
\code{qpcrANOVAFC} or \code{qpcrREPEATED}.
}
\details{
The \code{qpcrMeans} performs fold change (\eqn{\Delta \Delta C_T} method) analysis using a model produced by the
\code{qpcrANOVAFC} or \code{qpcrREPEATED}. The values can be returned for any effects in the model including simple effects,
interactions and slicing if an ANOVA model is used, but ANCOVA models returned by rtpcr package only include simple effects.
}
\examples{

# Returning fold change values from a fitted model.
# Firstly, result of `qpcrANOVAFC` or `qpcrREPEATED` is 
# acquired which includes a model object:
res <- qpcrANOVAFC(data_3factor, numberOfrefGenes = 1, mainFactor.column = 1)

# Returning fold change values of Type levels from a fitted model:
qpcrMeans(res$lm_ANOVA, specs = "Type")

# Returning fold change values of Conc levels from a fitted model:
qpcrMeans(res$lm_ANOVA, specs = "Conc")

# Returning fold change values of Conc levels sliced by Type:
qpcrMeans(res$lm_ANOVA, specs = "Conc | Type")

# Returning fold change values of Conc levels sliced by Type*SA:
qpcrMeans(res$lm_ANOVA, specs = "Conc | (Type*SA)")


}
\author{
Ghader Mirzaghaderi
}
