% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{df_select}
\alias{df_select}
\title{Select Columns in a Data Frame}
\usage{
df_select(data, ..., vars = NULL)
}
\arguments{
\item{data}{a data frame}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used to select a variable of interest.}

\item{vars}{a character vector containing the variable names of interest.}
}
\value{
a data frame
}
\description{
A wrapper around the \code{\link[dplyr]{select}()} function for
  selection data frame columns. Supports standard and non standard
  evaluations. Usefull to easily program with \code{dplyr}
}
\examples{
df <- head(ToothGrowth)
df

# Select column using standard evaluation
df \%>\% df_select(vars = c("dose", "len"))

# Select column using non-standard evaluation
df \%>\% df_select(dose, len)
}
