% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_and_sign.R
\name{sign_planetary_computer}
\alias{sign_planetary_computer}
\title{Sign STAC items retrieved from the Planetary Computer}
\usage{
sign_planetary_computer(items, subscription_key = Sys.getenv("rsi_pc_key"))
}
\arguments{
\item{items}{A STACItemCollection, as returned by \code{rsi_query_api}.}

\item{subscription_key}{Optionally, a subscription key associated with your
Planetary Computer account. At the time of writing, this is required for
downloading Sentinel 1 RTC products, as well as NAIP imagery. This key will
be automatically used if the environment variable \code{rsi_pc_key} is set.}
}
\value{
A STACItemCollection object with signed assets url.
}
\description{
Sign STAC items retrieved from the Planetary Computer
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aoi <- sf::st_point(c(-74.912131, 44.080410))
aoi <- sf::st_set_crs(sf::st_sfc(aoi), 4326)
aoi <- sf::st_buffer(sf::st_transform(aoi, 5070), 100)

landsat_image <- get_landsat_imagery(
  aoi,
  start_date = "2022-06-01",
  end_date = "2022-08-30",
  sign_function = sign_planetary_computer
)
\dontshow{\}) # examplesIf}
}
