% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usage.R
\name{showMetrics}
\alias{showMetrics}
\title{Show Application Metrics}
\usage{
showMetrics(
  metricSeries,
  metricNames,
  appDir = getwd(),
  appName = NULL,
  account = NULL,
  server = "shinyapps.io",
  from = NULL,
  until = NULL,
  interval = NULL
)
}
\arguments{
\item{metricSeries}{Metric series to query. Refer to the
\href{https://docs.posit.co/shinyapps.io/metrics.html#ApplicationMetrics}{shinyapps.io documentation}
for available series.}

\item{metricNames}{Metric names in the series to query. Refer to the
\href{https://docs.posit.co/shinyapps.io/metrics.html#ApplicationMetrics}{shinyapps.io documentation}
for available metrics.}

\item{appDir}{A directory containing an application (e.g. a Shiny app
or plumber API). Defaults to the current directory.}

\item{appName}{Application name, a string consisting of letters, numbers,
\verb{_} and \code{-}. The application name is used to identify applications on a
server, so much be unique.

If not specified, the first deployment will be automatically it from the
\code{appDir} for directory and website, and from the \code{appPrimaryDoc} for
document. On subsequent deploys, it will use the previously stored value.}

\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}

\item{from}{Date range starting timestamp (Unix timestamp or relative time
delta such as "2d" or "3w").}

\item{until}{Date range ending timestamp (Unix timestamp or relative time
delta such as "2d" or "3w").}

\item{interval}{Summarization interval. Data points at intervals less then this
will be grouped. (Relative time delta e.g. "120s" or "1h" or "30d").}
}
\description{
Show application metrics of a currently deployed application.
This function only works for ShinyApps servers.
}
