% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rr_journal_find.R
\name{rr_journal_find}
\alias{rr_journal_find}
\title{Find if journals are available in SHERPA/RoMEO}
\usage{
rr_journal_find(name, qtype = c("exact", "contains", "starts"),
  key = NULL)
}
\arguments{
\item{name}{[\code{character(1+)}]\cr{}
one or several strings to match the titles of the journals}

\item{qtype}{[\code{character(1)}]\cr{}
in:
* \code{"exact"} full title must be exactly to provided \code{name},
* \code{"contains"} the provided \code{name} must appear anywhere in the
title of the journal,
* \code{"starts"} the provided \code{name} must appear at the start of
title of the journal.}

\item{key}{[\code{character(1)}]\cr{}
a character string containing the API key or \code{NULL}
(see Details section on how to specify it)}
}
\value{
Returns a data frame:
\itemize{
\item \code{title}        [\code{character(1)}]\cr{}
the name of the journal
\item \code{issn}         [\code{character(1)}]\cr{}
the ISSN of the journal
}
}
\description{
Find if journals are available in SHERPA/RoMEO
}
\details{
There are several ways to provide your API key.
The best way to know about them is to refer to the vignette about
"Setting Up Your API key" accessible with the following command:
\code{vignette("setting_up_api_key", package = "rromeo")}.
You can also use \code{\link{rr_auth}} that will use the provided key to store it as
an environmental variable.
}
\examples{
\donttest{
rr_journal_find(name = "Biostatistics", qtype = "contains")
}

}
