% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRepast.R
\name{getExperimentParamSet}
\alias{getExperimentParamSet}
\title{Helper function to get experiment \code{paramset}}
\usage{
getExperimentParamSet(e)
}
\arguments{
\item{e}{The experiement object returned by \code{\link{RunExperiment}}}
}
\value{
The reference to \code{output} container.
}
\description{
The RunExperiment function returns a list holding
the \code{paramset}, \code{output} and \code{dataset} collection.
The \code{paramset} collection contains the parameters used for
running the experimental setup. The \code{output} has the results
from user provided calibration function. The \code{dataset}
collection has the raw output of 'Repast' aggregated dataset.
}
\examples{
\dontrun{
   d<- "C:/usr/models/your-model-directory"
   m<- Model(d)
   ...
   e<- RunExperiment(e,r=1,exp.design,my.cost)
   p<- getExperimentParamSet(e)}

}
