% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reducers.R
\name{rray_sum}
\alias{rray_sum}
\title{Calculate the sum along an axis}
\usage{
rray_sum(x, axes = NULL)
}
\arguments{
\item{x}{A vector, matrix, or array to reduce.}

\item{axes}{An integer vector specifying the axes to reduce over. \code{1} reduces
the number of rows to 1, performing the reduction along the way. \code{2} does the
same, but with the columns, and so on for higher dimensions. The default
reduces along all axes.}
}
\value{
The result of the reduction as a double with the same shape as \code{x}, except
along \code{axes}, which have been reduced to size 1.
}
\description{
\code{rray_sum()} computes the sum along a given axis or axes. The dimensionality
of \code{x} is retained in the result.
}
\examples{

x <- rray(1:10, c(5, 2))

# Reduce the number of rows to 1,
# summing along the way
rray_sum(x, 1)

# Reduce the number of columns to 1,
# summing along the way
rray_sum(x, 2)

# Reduce along all axes, but keep dimensions
rray_sum(x)

# Column-wise proportions
x / rray_sum(x, 1)

# Row-wise proportions
x / rray_sum(x, 2)

# Reducing over multiple axes
# This reduces over the rows and columns
# of each mini-matrix in the 3rd dimension
y <- rray(1:24, c(2, 3, 4))
rray_sum(y, c(1, 2))

}
\seealso{
Other reducers: \code{\link{rray_max}},
  \code{\link{rray_mean}}, \code{\link{rray_min}},
  \code{\link{rray_prod}}
}
\concept{reducers}
