% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natural_join.R
\name{natural_join}
\alias{natural_join}
\title{Make a natural_join node.}
\usage{
natural_join(a, b, ..., jointype = "INNER", by = NULL)
}
\arguments{
\item{a}{source to select from.}

\item{b}{source to select from.}

\item{...}{force later arguments to bind by name}

\item{jointype}{type of join ('INNER', 'LEFT', 'RIGHT', 'FULL').}

\item{by}{set of columns to match.}
}
\value{
natural_join node.
}
\description{
Natural join is a join by identity on all common columns
(or only common columns specified in a non-\code{NULL} \code{by} argument).
Any common columns not specified in a non-\code{NULL} \code{by} argument
are coalesced into a single column prefering the first or "a" table.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d1 <- dbi_copy_to(my_db, 'd1',
                    data.frame(AUC = 0.6, R2 = 0.2, D = NA))
  d2 <- dbi_copy_to(my_db, 'd2',
                    data.frame(AUC = 0.6, D = 0.3))
  optree <- natural_join(d1, d2, by = 'AUC')
  cat(format(optree))
  sql <- to_sql(optree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
