% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgGetBoundary.R
\name{pgGetBoundary}
\alias{pgGetBoundary}
\title{Retrieve bounding envelope of geometries or rasters.}
\usage{
pgGetBoundary(conn, name, geom = "geom")
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{A character string specifying a PostgreSQL schema and
table/view name holding the geometry (e.g., \code{name =
c("schema","table")})}

\item{geom}{character, Name of the column in \code{name} holding the
geometry or raster object (Default = \code{"geom"})}
}
\value{
SpatialPolygon
}
\description{
Retrieve bounding envelope (rectangle) of all geometries or
rasters in a PostGIS table.
}
\examples{
\dontrun{
pgGetBoundary(conn, c("schema", "polys"), geom = "polygon")
pgGetBoundary(conn, c("schema", "rasters"), geom = "rast")
}
}
\author{
David Bucklin \email{dbucklin@ufl.edu}
}
