% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listspecies.R
\name{insert_species_in_list}
\alias{insert_species_in_list}
\title{Insert list of species}
\usage{
insert_species_in_list(userid, listObj)
}
\arguments{
\item{userid}{A valid gmail address of the user}

\item{listObj}{A list object}
}
\value{
A list with the id of the new list created
}
\description{
Insert list of species
}
\examples{
  userid = "abusalehmdtayeen@gmail.com"
  listObj = list(list_extra_info="", list_description="A sublist on the bird species added",
      list_keywords=c("bird", "endangered species", "Everglades"),
      list_curator="HD Laughinghouse", list_origin="webapp",
      list_curation_date="02-24-2016", list_source="des", list_focal_clade="Aves",
      list_title="Bird Species List",list_author=c("Bass", "O. & Cunningham", "R."),
      list_date_published="01-01-2017", is_list_public=TRUE,
      list_species=list(list(family="",scientific_name="Aix sponsa",
          scientific_name_authorship="", vernacular_name="Wood Duck",
          phylum="",nomenclature_code="ICZN",order="Anseriformes",class=""),
          list(family="",scientific_name="Anas strepera",
          scientific_name_authorship="", vernacular_name="Gadwall",
          phylum="",nomenclature_code="ICZN",
          order="Anseriformes",class="") ))
  insert_species_in_list(userid, listObj)
}
\seealso{
\url{https://github.com/phylotastic/phylo_services_docs/tree/master/ServiceDescription}
}
