% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_plan_means.R
\name{getSampleSizeMeans}
\alias{getSampleSizeMeans}
\title{Get Sample Size Means}
\usage{
getSampleSizeMeans(
  design = NULL,
  ...,
  groups = 2,
  normalApproximation = FALSE,
  meanRatio = FALSE,
  thetaH0 = ifelse(meanRatio, 1, 0),
  alternative = seq(0.2, 1, 0.2),
  stDev = 1,
  allocationRatioPlanned = NA_real_
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used.
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower},
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{normalApproximation}{The type of computation of the p-values. If \code{TRUE}, the variance is
assumed to be known, default is \code{FALSE}, i.e., the calculations are performed
with the t distribution.}

\item{meanRatio}{If \code{TRUE}, the sample size for
one-sided testing of H0: \code{mu1 / mu2 = thetaH0} is calculated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value,
default is \code{0} for the normal and the binary case (testing means and rates, respectively),
it is \code{1} for the survival case (testing the hazard ratio).\cr\cr
For non-inferiority designs, \code{thetaH0} is the non-inferiority bound.
That is, in case of (one-sided) testing of
\itemize{
\item \emph{means}: a value \code{!= 0}
(or a value \code{!= 1} for testing the mean ratio) can be specified.
\item \emph{rates}: a value \code{!= 0}
(or a value \code{!= 1} for testing the risk ratio \code{pi1 / pi2}) can be specified.
\item \emph{survival data}: a bound for testing H0: \code{hazard ratio = thetaH0 != 1} can be specified.
\item \emph{count data}: a bound for testing H0: \code{lambda1 / lambda2 = thetaH0 != 1} can be specified.
}
For testing a rate in one sample, a value \code{thetaH0} in (0, 1) has to be specified for
defining the null hypothesis H0: \code{pi = thetaH0}.}

\item{alternative}{The alternative hypothesis value for testing means. This can be a vector of assumed
alternatives, default is \code{seq(0, 1, 0.2)} (power calculations) or \code{seq(0.2, 1, 0.2)} (sample size calculations).}

\item{stDev}{The standard deviation under which the sample size or power
calculation is performed, default is \code{1}.
If \code{meanRatio = TRUE} is specified, \code{stDev} defines
the coefficient of variation \code{sigma / mu2}. Must be a positive numeric of length 1.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups
design, default is \code{1}. If \code{allocationRatioPlanned = 0} is entered,
the optimal allocation ratio yielding the smallest overall sample size is determined.}
}
\value{
Returns a \code{\link{TrialDesignPlan}} object.
The following generics (R generic functions) are available for this result object:
\itemize{
\item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
\item \code{\link[=print.FieldSet]{print()}} to print the object,
\item \code{\link[=summary.TrialDesignSet]{summary()}} to display a summary of the object,
\item \code{\link[=plot.TrialDesignPlan]{plot()}} to plot the object,
\item \code{\link[=as.data.frame.TrialDesignPlan]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
\item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the sample size for testing means in one or two samples.
}
\details{
At given design the function calculates the stage-wise and maximum sample size for testing means.
In a two treatment groups design, additionally, an allocation ratio = \code{n1 / n2}
can be specified where \code{n1} and \code{n2} are the number of subjects in the two treatment groups.
A null hypothesis value thetaH0 != 0 for testing the difference of two means or
thetaH0 != 1 for testing the ratio of two means can be specified.
Critical bounds and stopping for futility bounds are provided at the effect scale
(mean, mean difference, or mean ratio, respectively) for each sample size calculation separately.
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of
the \code{rpact} specific implementation of the generic.
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and
to identify the object specific name of it, e.g.,
use \code{methods("plot")} to get all the methods for the \code{plot} generic.
There you can find, e.g., \code{plot.AnalysisResults} and
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
# Calculate sample sizes in a fixed sample size parallel group design 
# with allocation ratio \code{n1 / n2 = 2} for a range of 
# alternative values 1, ..., 5 with assumed standard deviation = 3.5; 
# two-sided alpha = 0.05, power 1 - beta = 90\%:
getSampleSizeMeans(alpha = 0.05, beta = 0.1, sided = 2, groups = 2, 
    alternative = seq(1, 5, 1), stDev = 3.5, allocationRatioPlanned = 2)
\dontrun{
# Calculate sample sizes in a three-stage Pocock paired comparison design testing 
# H0: mu = 2 for a range of alternative values 3,4,5 with assumed standard 
# deviation = 3.5; one-sided alpha = 0.05, power 1 - beta = 90\%:
getSampleSizeMeans(getDesignGroupSequential(typeOfDesign = "P", alpha = 0.05, 
    sided = 1, beta = 0.1), groups = 1, thetaH0 = 2, 
    alternative = seq(3, 5, 1), stDev = 3.5)
}

}
\seealso{
Other sample size functions: 
\code{\link{getSampleSizeCounts}()},
\code{\link{getSampleSizeRates}()},
\code{\link{getSampleSizeSurvival}()}
}
\concept{sample size functions}
