% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design.R
\name{plot.TrialDesign}
\alias{plot.TrialDesign}
\title{Trial Design Plotting}
\usage{
\method{plot}{TrialDesign}(
  x,
  y,
  ...,
  main = NA_character_,
  xlab = NA_character_,
  ylab = NA_character_,
  type = 1L,
  palette = "Set1",
  theta = seq(-1, 1, 0.01),
  nMax = NA_integer_,
  plotPointsEnabled = NA,
  legendPosition = NA_integer_,
  showSource = FALSE,
  grid = 1,
  plotSettings = NULL
)
}
\arguments{
\item{x}{The trial design, obtained from \cr
\code{\link{getDesignGroupSequential}}, \cr
\code{\link{getDesignInverseNormal}} or \cr
\code{\link{getDesignFisher}}.}

\item{y}{Not available for this kind of plot (is only defined to be compatible to the generic plot function).}

\item{...}{Optional plot arguments. At the moment \code{xlim} and \code{ylim} are implemented 
for changing x or y axis limits without dropping data observations.}

\item{main}{The main title.}

\item{xlab}{The x-axis label.}

\item{ylab}{The y-axis label.}

\item{type}{The plot type (default = \code{1}). The following plot types are available:
\itemize{
  \item \code{1}: creates a 'Boundaries' plot
  \item \code{3}: creates a 'Stage Levels' plot
  \item \code{4}: creates a 'Error Spending' plot
  \item \code{5}: creates a 'Power and Early Stopping' plot
  \item \code{6}: creates an 'Average Sample Size and Power / Early Stop' plot
  \item \code{7}: creates an 'Power' plot
  \item \code{8}: creates an 'Early Stopping' plot
  \item \code{9}: creates an 'Average Sample Size' plot
  \item \code{"all"}: creates all available plots and returns it as a grid plot or list
}}

\item{palette}{The palette, default is \code{"Set1"}.}

\item{theta}{A vector of standardized effect sizes (theta values), default is a sequence from -1 to 1.}

\item{nMax}{The maximum sample size.}

\item{plotPointsEnabled}{If \code{TRUE}, additional points will be plotted.}

\item{legendPosition}{The position of the legend. 
By default (\code{NA_integer_}) the algorithm tries to find a suitable position. 
Choose one of the following values to specify the position manually:
\itemize{
  \item \code{-1}: no legend will be shown
  \item \code{NA}: the algorithm tries to find a suitable position
  \item \code{0}: legend position outside plot
  \item \code{1}: legend position left top
  \item \code{2}: legend position left center
  \item \code{3}: legend position left bottom
  \item \code{4}: legend position right top
  \item \code{5}: legend position right center
  \item \code{6}: legend position right bottom
}}

\item{showSource}{If \code{TRUE}, the parameter names of the object will 
be printed which were used to create the plot; that may be, e.g., 
useful to check the values or to create own plots with the base R \code{plot} function.
Alternatively \code{showSource} can be defined as one of the following character values: 
\itemize{
  \item \code{"commands"}: returns a character vector with plot commands
  \item \code{"axes"}: returns a list with the axes definitions
  \item \code{"test"}: all plot commands will be validated with \code{eval(parse())} and 
        returned as character vector (function does not stop if an error occurs)
  \item \code{"validate"}: all plot commands will be validated with \code{eval(parse())} and 
        returned as character vector (function stops if an error occurs)
}
Note: no plot object will be returned if \code{showSource} is a character.}

\item{grid}{An integer value specifying the output of multiple plots. 
By default (\code{1}) a list of \code{ggplot} objects will be returned. 
If a \code{grid} value > 1 was specified, a grid plot will be returned 
if the number of plots is <= specified \code{grid} value; 
a list of \code{ggplot} objects will be returned otherwise.
If \code{grid = 0} is specified, all plots will be created using \code{\link[base]{print}} command 
and a list of \code{ggplot} objects will be returned invisible. 
Note that one of the following packages must be installed to create a grid plot: 
'ggpubr', 'gridExtra', or 'cowplot'.}

\item{plotSettings}{An object of class \code{PlotSettings} created by \code{\link{getPlotSettings}}.}
}
\value{
Returns a \code{ggplot2} object.
}
\description{
Plots a trial design.
}
\details{
Generic function to plot a trial design.

Generic function to plot a trial design.

Note that \code{\link[=param_nMax]{nMax}} is not an argument that it passed to \code{ggplot2}. 
Rather, the underlying calculations (e.g. power for different theta's or average sample size) are based 
on calls to function \code{\link{getPowerAndAverageSampleNumber}} which has argument \code{\link[=param_nMax]{nMax}}. 
I.e., \code{\link[=param_nMax]{nMax}} is not an argument to ggplot2 but to \code{\link{getPowerAndAverageSampleNumber}} 
which is called prior to plotting.
}
\examples{
\donttest{
design <- getDesignInverseNormal(kMax = 3, alpha = 0.025, 
    typeOfDesign = "asKD", gammaA = 2, 
    informationRates = c(0.2, 0.7, 1), 
    typeBetaSpending = "bsOF")
if (require(ggplot2)) {
    plot(design) # default: type = 1
}
}

}
\seealso{
\code{\link{plot.TrialDesignSet}} to compare different designs or design parameters visual.
}
