% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_analysis.R
\name{getStageResults}
\alias{getStageResults}
\title{Get Stage Results}
\usage{
getStageResults(design, dataInput, ...)
}
\arguments{
\item{design}{The trial design.}

\item{dataInput}{The summary data used for calculating the test results. 
This is either an element of \code{DatasetMeans}, of \code{DatasetRates}, or of \code{DatasetSurvival}. 
See \code{\link{getDataset}}.}

\item{...}{Further (optional) arguments to be passed:
\describe{
  \item{stage}{The stage number (optional). Default: total number of existing stages in the data input.}
  \item{thetaH0}{The null hypothesis value, default is 0 for the normal and the binary case, 
      it is 1 for the survival case.      
      For testing a rate in one sample, a value thetaH0 in (0, 1) has to be specified for 
      defining the null hypothesis H0: pi = thetaH0. \cr
         For noninferiority designs, this is the noninferiority bound. } 
  \item{thetaH1 and assumedStDev or pi1, pi2}{The assumed effect size or assumed rates to calculate the 
      conditional power. Depending on the type of dataset, either thetaH1 (means and survival) 
      or pi1, pi2 (rates) can be specified. Additionally, if testing means is specified, 
      an assumed standard deviation can be specified, default is 1.}
  \item{normalApproximation}{The type of computation of the p-values. Default is FALSE for 
      testing means (i.e., the t test is used) and TRUE for testing rates and the hazard ratio. 
      For testing rates, if \cr 
      \code{normalApproximation = FALSE} is specified, the binomial test 
      (one sample) or the test of Fisher (two samples) is used for calculating the p-values.
      In the survival setting, \cr
      \code{normalApproximation = FALSE} has no effect.}  
  \item{equalVariances}{The type of t test. For testing means in two treatment groups, either 
      the t test assuming that the variances are equal or the t test without assuming this, 
      i.e., the test of Welch-Satterthwaite is calculated, default is \code{equalVariances = TRUE}.}
  \item{directionUpper}{The direction of one-sided testing. 
      Default is \code{directionUpper = TRUE} which means that larger values of the 
      test statistics yield smaller p-values.}
}}
}
\value{
Returns a \code{StageResults} object.
}
\description{
Returns summary statistics and p-values for a given data set and a given design.
}
\details{
Calculates and returns the stage results of the specified design and data input at the specified stage.
}
\examples{
design <- getDesignInverseNormal()
dataRates <- getDataset(
    n1 = c(10,10),
    n2 = c(20,20),
    events1 = c(8,10),
    events2 = c(10,16))

getStageResults(design, dataRates)

# produces:
#
# Stage results of rates:
#   Stages                     : 1, 2, 3 
#   Overall test statistics    : 1.581, 2.064, NA 
#   Overall p-values           : 0.05692, 0.01949, NA 
#   Overall events (1)         : 8, 18 
#   Overall events (2)         : 10, 26 
#   Overall sample sizes (1)   : 10, 20 
#   Overall sample sizes (2)   : 20, 40 
#   Test statistics            : 1.581, 1.519, NA 
#   p-values                   : 0.05692, 0.06437, NA 
#   Effect sizes               : 0.30, 0.25, NA 
#   Inverse Normal Combination : 1.581, 2.192, NA 
#   Weights Inverse Normal     : 0.577, 0.577, 0.577 
#   Theta H0                   : 0 
#   Direction                  : upper 
#   Normal approximation       : TRUE 

}
