% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rotationForest.R
\name{rotationForest}
\alias{rotationForest}
\title{Binary classification with Rotation Forest (Rodriguez en Kuncheva, 2006)}
\usage{
rotationForest(x, y, K = round(ncol(x)/3, 0), L = 10, ...)
}
\arguments{
\item{x}{A data frame of predictors (numeric, or integer). Categorical variables need to be transformed to indicator (dummy) variables.}

\item{y}{A factor containing the response vector. Only \{0,1\} is allowed.}

\item{K}{The number of variable subsets. The default is the value \code{K} that results in three features per subset.}

\item{L}{The number of base classfiers (trees using the \code{rpart} package). The default is 10.}

\item{...}{Arguments to \code{rpart.control} of the \code{rpart} package. Firt run \code{library(rpart)}.}
}
\value{
An object of class \code{rotationForest}, which is a list with the following elements:
  \item{models}{A list of trees.}
  \item{loadings}{A list of loadings.}
  \item{columnnames}{Column names of x.}
}
\description{
\code{rotationForest} implements an ensemble method where each base classifier (tree) is fit on the principal components of the variables of random partitions of the feature set.
}
\examples{
data(iris)
y <- as.factor(ifelse(iris$Species[1:100]=="setosa",0,1))
x <- iris[1:100,-5]
rF <- rotationForest(x,y)
predict(object=rF,newdata=x)
}
\author{
Authors: Michel Ballings and Dirk Van den Poel, Maintainer: \email{Michel.Ballings@GMail.com}
}
\references{
Rodriguez, J.J., Kuncheva, L.I., 2006. Rotation forest: A new classifier ensemble method. IEEE Trans. Pattern Anal. Mach. Intell. 28, 1619-1630. doi:10.1109/TPAMI.2006.211
}
\seealso{
\code{\link{predict.rotationForest}}
}
\keyword{classification}

