% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.rolog.R
\name{as.rolog}
\alias{as.rolog}
\title{Translate simplified to canonical representation}
\usage{
as.rolog(query = quote(member(.X, ""[a, "b", 3L, 4, (pi), TRUE, .Y])))
}
\arguments{
\item{query}{an R call representing a Prolog query with prolog-like syntax,
e.g., `member(.X, ""[a, b, .Y])` for use in [query()], [once()], 
and [findall()]. The argument is translated to Rolog's representation, 
with R calls corresponding to Prolog terms and R expressions corresponding to
Prolog variables. Variables and expressions in parentheses are evaluated.}
}
\description{
Translate simplified to canonical representation
}
\examples{
q <- quote(member(.X, ""[a, "b", 3L, 4, pi, (pi), TRUE, .Y]))
as.rolog(q)

q <- quote(member(.X, ""[a, "b", 3L, 4, pi, (pi), TRUE, .Y]))
findall(as.rolog(q))

}
\seealso{
[query()], [once()], [findall()]
}
