% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_quantile}
\alias{roll_quantile}
\title{Rolling Quantiles}
\usage{
roll_quantile(x, width, weights = rep(1, width), p = 0.5,
  min_obs = width, complete_obs = FALSE, na_restore = FALSE,
  online = FALSE)
}
\arguments{
\item{x}{vector or matrix. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{p}{numeric. Probability between zero and one.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then each value is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
An object of the same class and dimension as \code{x} with the rolling and expanding
quantiles.
}
\description{
A function for computing the rolling and expanding quantiles of time-series data.
}
\details{
The methodology for computing the quantiles is based on the inverse of the empirical
distribution function with averaging at discontinuities (see "Definition 2" in Hyndman and Fan, 1996).
}
\examples{
n <- 15
x <- rnorm(n)
weights <- 0.9 ^ (n:1)

# rolling quantiles with complete windows
roll_quantile(x, width = 5)

# rolling quantiles with partial windows
roll_quantile(x, width = 5, min_obs = 1)

# expanding quantiles with partial windows
roll_quantile(x, width = n, min_obs = 1)

# expanding quantiles with partial windows and weights
roll_quantile(x, width = n, min_obs = 1, weights = weights)
}
\references{
Hyndman, R.J. and Fan, Y. (1996). "Sample quantiles in statistical packages."
\emph{American Statistician}, 50(4), 361-365.
}
