% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_crossprod}
\alias{roll_crossprod}
\title{Rolling Crossproducts}
\usage{
roll_crossprod(x, y = NULL, width, weights = rep(1, width),
  center = FALSE, scale = FALSE, min_obs = width, complete_obs = TRUE,
  na_restore = FALSE, online = TRUE)
}
\arguments{
\item{x}{vector or matrix. Rows are observations and columns are variables.}

\item{y}{vector or matrix. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{center}{logical. If \code{TRUE} then the weighted mean of each variable is used,
if \code{FALSE} then zero is used.}

\item{scale}{logical. If \code{TRUE} then the weighted standard deviation of each variable is used,
if \code{FALSE} then no scaling is done.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then pairwise is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
A cube with each slice the rolling and expanding crossproducts.
}
\description{
A function for computing the rolling and expanding crossproducts of time-series data.
}
\examples{
n <- 15
x <- rnorm(n)
y <- rnorm(n)
weights <- 0.9 ^ (n:1)

# rolling crossproducts with complete windows
roll_crossprod(x, y, width = 5)

# rolling crossproducts with partial windows
roll_crossprod(x, y, width = 5, min_obs = 1)

# expanding crossproducts with partial windows
roll_crossprod(x, y, width = n, min_obs = 1)

# expanding crossproducts with partial windows and weights
roll_crossprod(x, y, width = n, min_obs = 1, weights = weights)
}
