
test_that("R6 object status error", {
  db <- rocker::rocker$new(verbose = FALSE)
  # drv -, con -, tra -, res -
  expect_true(is.null(db$info))
  expect_true(is.null(db$.drv))
  expect_true(is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  # expect_error(db$initialize())
  # expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$setupDriver(RSQLite::SQLite(), dbname = ":memory:")
  # drv +, con -, tra -, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  # expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  # expect_error(db$unloadDriver())

  db$connect()
  # drv +, con +, tra -, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  # expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  # expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$writeTable("mtcars", mtcars)
  # drv +, con +, tra -, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  # expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  # expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$sendQuery("SELECT * FROM mtcars;")
  # drv +, con +, tra -, res +
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(!is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  # expect_error(db$fetch())
  # expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  out <- db$fetch()
  rm(out)
  # drv +, con +, tra -, res +
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(!is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  # expect_error(db$fetch())
  # expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$clearResult()
  # drv +, con +, tra -, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  # expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  # expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$begin()
  # drv +, con +, tra +, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(!isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  # expect_error(db$commit())
  # expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
  # drv +, con +, tra +, res +
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(!isFALSE(db$transaction))
  expect_true(!is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  # expect_error(db$fetch())
  # expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$clearResult()
  # drv +, con +, tra +, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(!isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  # expect_error(db$commit())
  # expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$rollback()
  # drv +, con +, tra -, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  # expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  # expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$begin()
  # drv +, con +, tra +, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(!isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  # expect_error(db$commit())
  # expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$sendStatement("DELETE FROM mtcars WHERE gear = 3;")
  # drv +, con +, tra +, res +
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(!isFALSE(db$transaction))
  expect_true(!is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  # expect_error(db$fetch())
  # expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$clearResult()
  # drv +, con +, tra +, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(!isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  # expect_error(db$commit())
  # expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$commit()
  # drv +, con +, tra -, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(!is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  # expect_error(db$writeTable("mtcars", mtcars))
  # expect_error(db$begin())
  # expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  # expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  # expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  db$disconnect()
  # drv +, con -, tra -, res -
  expect_true(!is.null(db$info))
  expect_true(!is.null(db$.drv))
  expect_true(is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  expect_error(db$initialize())
  expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  # expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  # expect_error(db$unloadDriver())

  db$unloadDriver()
  # drv -, con -, tra -, res -
  expect_true(is.null(db$info))
  expect_true(is.null(db$.drv))
  expect_true(is.null(db$.con))
  expect_true(isFALSE(db$transaction))
  expect_true(is.null(db$.res))
  # expect_error(db$initialize())
  # expect_error(db$setupDriver(RSQLite::SQLite(), dbname = ":memory:"))
  expect_error(db$connect())
  expect_error(db$writeTable("mtcars", mtcars))
  expect_error(db$begin())
  expect_error(db$sendQuery("SELECT * FROM mtcars;"))
  expect_error(db$sendStatement("DELETE FROM mtcars WHERE gear = 3;"))
  expect_error(db$fetch())
  expect_error(db$clearResult())
  expect_error(db$commit())
  expect_error(db$rollback())
  expect_error(db$disconnect())
  expect_error(db$unloadDriver())

  rm(db)
})
