% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{setupPostgreSQL}
\alias{setupPostgreSQL}
\title{Setup database driver and define connection parameters for PostgreSQL using \link[RPostgres:Postgres]{RPostgres} package.
Wrapper for setupDriver() function.}
\usage{
setupPostgreSQL(
  db,
  host = "127.0.0.1",
  port = "5432",
  dbname = "mydb",
  user = "postgres",
  password = "password",
  ...,
  protect = c("password", "user")
)
}
\arguments{
\item{db}{rocker object}

\item{host}{Host name or IP number}

\item{port}{Port number}

\item{dbname}{Database name}

\item{user}{User name}

\item{password}{Password}

\item{...}{Optional, additional suitable parameters passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{protect}{Parameters to be hidden}
}
\value{
Invisible self
}
\description{
Setup database driver and define connection parameters for PostgreSQL using \link[RPostgres:Postgres]{RPostgres} package.
Wrapper for setupDriver() function.
}
\examples{
db <- rocker::newDB()
rocker::setupPostgreSQL(
  db,
  host = "127.0.0.1", port = "5432", dbname = "mydb",
  user = "postgres", password = "password"
)
rocker::unloadDriver(db)
}
