% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_heatmap.R
\name{ci_heatmap}
\alias{ci_heatmap}
\title{Create a heatmap showing issues with items}
\usage{
ci_heatmap(
  x,
  nrmSpec = NULL,
  language = nrmSpec$defaultLanguage,
  wrapLabels = 80,
  itemOrder = NULL,
  itemLabels = NULL,
  itemIdentifier = "uiid",
  codingScheme = "peterson",
  itemlab = NULL,
  codelab = NULL,
  freqlab = "Count",
  plotTitle = "Cognitive Interview Heatmap",
  fillScale = ggplot2::scale_fill_viridis_c(),
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{x}{The object with the parsed coded source(s) as resulting from a
call to \code{\link[=parse_source]{parse_source()}} or \code{\link[=parse_sources]{parse_sources()}}.}

\item{nrmSpec}{Optionally, an imported Narrative Response Model
specification, as imported with \code{\link[=ci_import_nrm_spec]{ci_import_nrm_spec()}}, which will
then be used to obtain the item labels.}

\item{language}{If \code{nrmSpec} is specified, the language to use.}

\item{wrapLabels}{Whether to wrap the labels; if not \code{NULL}, the
number of character to wrap at.}

\item{itemOrder, itemLabels}{Instead of specifying an NRM specification,
you can also directly specify the item order and item labels. \code{itemOrder}
is a character vector of item identifiers, and \code{itemLabels} is a named
character vector of item labels, where each value's name is the
corresponding item identifier. If \code{itemLabels} is provided but \code{itemOrder}
is not, the order of the \code{itemLabel} is used.}

\item{itemIdentifier}{The column identifying the items; the class instance
identifier prefix, e.g. if item identifiers are specified as
\verb{[[uiid:familySize_7djdy62d]]}, the \code{itemIdentifier} to pass here
is \code{"uiid"}.}

\item{codingScheme}{The coding scheme, either as a string if it represents
one of the cognitive interviewig coding schemes provided with the \code{rock}
package, or as a coding scheme resulting from a call
to \code{\link[=create_codingScheme]{create_codingScheme()}}.}

\item{itemlab, codelab, freqlab}{Labels to use for the item and code axes
and for the frequency color legend (\code{NULL} to omit the label).}

\item{plotTitle}{The title to use for the plot}

\item{fillScale}{Convenient way to specify the fill scale (the colours)}

\item{theme}{Convenient way to specify the \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} theme.}
}
\value{
The heatmap as a ggplot2 plot.
}
\description{
When conducting cognitive interviews, it can be useful to quickly inspect
the code distributions for each item. These heatmaps facilitate that
process.
}
\examples{
examplePath <- file.path(system.file(package="rock"), 'extdata');
parsedCI <- rock::parse_source(
  file.path(examplePath,
            "ci_example_1.rock")
);

rock::ci_heatmap(parsedCI,
                 codingScheme = "peterson");
}
