% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_source_by_coderId.R,
%   R/parse_sources_by_coderId.R
\name{parse_source_by_coderId}
\alias{parse_source_by_coderId}
\alias{parse_sources_by_coderId}
\title{Parsing sources separately for each coder}
\usage{
parse_source_by_coderId(
  input,
  ignoreOddDelimiters = FALSE,
  postponeDeductiveTreeBuilding = TRUE,
  rlWarn = rock::opts$get(rlWarn),
  encoding = "UTF-8",
  silent = TRUE
)

parse_sources_by_coderId(
  input,
  recursive = TRUE,
  filenameRegex = ".*",
  ignoreOddDelimiters = FALSE,
  postponeDeductiveTreeBuilding = TRUE,
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{input}{For \code{parse_source_by_coderId}, either a character vector
containing the text of the relevant source \emph{or} a path to a file that
contains the source text; for \code{parse_sources_by_coderId}, a path to a
directory that contains the sources to parse.}

\item{ignoreOddDelimiters}{If an odd number of YAML delimiters is encountered, whether this
should result in an error (\code{FALSE}) or just be silently ignored (\code{TRUE}).}

\item{postponeDeductiveTreeBuilding}{Whether to imediately try to build the deductive
tree(s) based on the information in this file (\code{FALSE}) or whether to skip that. Skipping
this is useful if the full tree information is distributed over multiple files (in which case
you should probably call \code{parse_sources} instead of \code{parse_source}).}

\item{rlWarn}{Whether to let \code{\link[=readLines]{readLines()}} warn, e.g. if files do not end
with a newline character.}

\item{encoding}{The encoding of the file to read (in \code{file}).}

\item{silent}{Whether to provide (\code{FALSE}) or suppress (\code{TRUE}) more detailed progress updates.}

\item{recursive}{Whether to search all subdirectories (\code{TRUE}) as well or not.}

\item{filenameRegex}{A regular expression to match against located files; only
files matching this regular expression are processed.}
}
\value{
For \code{rock::parse_source_by_coderId()}, an object of
class \code{rock_parsedSource}; for \code{rock::parse_sources_by_coderId()}, an
object of class \code{rock_parsedSources}. These objects contain the original
source(s) as well as the final data frame with utterances and codes, as
well as the code structures.
}
\description{
Parsing sources separately for each coder
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Parse single example source
parsedExample <- rock::parse_source_by_coderId(exampleFile);

}
