% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_to_txt.R
\name{doc_to_txt}
\alias{doc_to_txt}
\title{Convert a document (.docx, .pdf, .odt, .rtf, or .html) to a plain text file}
\usage{
doc_to_txt(
  input,
  output = NULL,
  encoding = rock::opts$get("encoding"),
  newExt = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{The path to the input file.}

\item{output}{The path and filename to write to. If this is a path to
an existing directory (without a filename specified), the \code{input} filename
will be used, and the extension will be replaced with \code{extension}.}

\item{encoding}{The encoding to use when writing the text file.}

\item{newExt}{The extension to append: only used if \code{output = NULL} and
\code{newExt} is not \code{NULL}, in which case the output will be written to a file
with the same name as \code{input} but with \code{newExt} as extension.}

\item{preventOverwriting}{Whether to prevent overwriting existing files.}

\item{silent}{Whether to the silent or chatty.}
}
\value{
The converted source, as a character vector.
}
\description{
This used to be a thin wrapper around \code{textreadr::read_document()} that also
writes the result to \code{output}, doing its best to correctly write UTF-8
(based on the approach recommended in \href{https://tomizonor.wordpress.com/2013/04/17/file-utf8-windows/}{this blog post}). However,
\code{textreadr} was archived from CRAN. It now directly wraps the functions
that \code{textreadr} wraps: \code{pdftools::pdf_text()}, \code{striprtf::read_rtf}, and
it uses \code{xml2} to import \code{.docx} and \code{.odt} files, and \code{rvest} to import
\code{.html} files, using the code from the \code{textreadr} package.
}
\examples{
### This example requires the {xml2} package
if (requireNamespace("xml2", quietly = TRUE)) {
  print(
    rock::doc_to_txt(
      input = system.file(
        "extdata/doc-to-test.docx", package="rock"
      )
    )
  );
}
}
