% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bound_index_computations.R
\name{LowerIndexBound}
\alias{LowerIndexBound}
\title{Lower bound of the uncertainty interval of the Rao-Stirling diversity index.}
\usage{
LowerIndexBound(known.ref.counts, uncat.ref.count, similarity,
  permissible.disciplines = NULL, redistribution.limit = 4,
  max.batch.size = 131072)
}
\arguments{
\item{known.ref.counts}{A vector of positive integers. Each element represents the count of references to each discipline.}

\item{uncat.ref.count}{A positive integer denoting the number of references that are not categorized into disciplines.}

\item{similarity}{A positive semi-definite matrix that encodes the similarity between disciplines, as explained in Porter and Rafols (2009).
The dimensions of this matrix are \emph{n} x \emph{n}, being \emph{n} the total number of disciplines.
The self-similarities (i.e. the diagonal elements) have to be 1.}

\item{permissible.disciplines}{A logical vector denoting to which disciplines uncategorized references can be distributed.
Its length needs to be equal to the length of \code{known.ref.counts}.
This argument is optional and leaving it unspecified or supplying NULL permits redistribution to all disciplines.}

\item{redistribution.limit}{A positive integer that limits the number of disciplines that each uncategorized reference can be redistributed to.
This argument is optional and leaving it unspecified permits redistribution to all disciplines at once.}

\item{max.batch.size}{A positive integer that sets the size of the batch of candidates that is computed at once.
This positive value determines the quantity of allocated memory and has to be reduced if corresponding errors arise.
This argument is optional and leaving it unspecified sets it to a default value.}
}
\value{
The lower bound of the uncertainty interval of the Rao-Stirling diversity index.
}
\description{
This function computes the lower bound of the uncertainty interval of the Rao-Stirling diversity index, as explained in Calatrava et al. (2016).
The computation involves the redistribution of uncategorized references to various disciplines.
In order to avoid improbable redistributions of disciplines, a set of permissible disciplines for redistribution can be defined.
Furthermore, the number of disciplines redistributed to uncategorized references can be limited.
}
\section{Warning}{

This function solves a computationally intensive optimization problem. In order to reduce the search space it is recommended to provide the function with the vector of permissible disciplines and redistribution limit.
When very dissimilar disciplines are referenced by the categorized references, a warning message is displayed to inform the user.
Such cases require longer computation times.
The dataset \code{\link{pubdata2}} contains an example of a publication that requires intensive computation in order to calculate the uncertainty interval of the Rao-Stirling diversity index.
}

\examples{
##EXAMPLE 1
#Load data
data(pubdata1)

#Get counts of citations of one of the publications in the dataset
counts <- pd1.count.matrix[,1]

#Get number of uncategorized references in the publication
uncat <- pd1.uncat.refs[1]

#Get vector of permissible disciplines.
logic.disciplines <- counts > 0
permissible <- PruneDisciplines(logic.disciplines, 0.233, pd1.similarity)

LowerIndexBound(counts, uncat, pd1.similarity, permissible)

}
\references{
Calatrava Moreno, M. C., Auzinger, T. and Werthner, H. (2016) On the uncertainty of interdisciplinarity measurements due to incomplete bibliographic data. Scientometrics. DOI:10.1007/s11192-016-1842-4

Porter, A. and Rafols, I. (2009) Is science becoming more interdisciplinary? Measuring and mapping six research fields over time. Scientometrics, Vol. 81, No. 3 (719-745). DOI:10.1007/s11192-008-2197-2
}
