% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robsurvey.R
\name{weighted_mad}
\alias{weighted_mad}
\title{Weighted median absolute deviation from the median (MAD)}
\usage{
weighted_mad(x, w, na.rm = FALSE, constant = 1.4826)
}
\arguments{
\item{x}{a numeric vector}

\item{w}{a numeric vector of weights}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}

\item{constant}{(scale factor, default: 1.4826)}
}
\value{
Weighted median absolute deviation from the (weighted) median
}
\description{
\code{weighted_mad} computes weighted median absolute deviation from the
weighted median
}
\details{
The weighted MAD is computed as the (normalized) weighted median of the
absolute deviation from the weighted median; the median is computed as the
weighted lower sample median (see \code{\link{weighted_median}}); the MAD
is normalized to be an unbiased estimate of scale at the Gaussian core model.
}
\examples{
x <- c(0.1, 0.35, 0.05, 0.1, 0.15, 0.05, 0.2)
weighted_mad(x, x)
}
\seealso{
\code{\link{weighted_median}}
}
