% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robomit_functions.R
\name{o_delta_rsq}
\alias{o_delta_rsq}
\title{delta*s over a range of maximum R-squares}
\usage{
o_delta_rsq(y, x, con, m = "none", id = "none", time = "none", beta = 0, type, data)
}
\arguments{
\item{y}{Name of the dependent variable (as string).}

\item{x}{Name of the independent treatment variable (i.e. variable of interest; as string).}

\item{con}{Name of the other control variables. Provided as string in the format: "w + z +...".}

\item{m}{Name of unrelated control variables (m; see Oster 2019; as string; default m = "none").}

\item{id}{Name of the individual id variable (e.g. firm or farm; as string). Only applicable for fixed effect panel models.}

\item{time}{Name of the time variable (e.g. year or month; as string). Only applicable for fixed effect panel models.}

\item{beta}{beta for which delta* should be estimated (default is beta = 0).}

\item{type}{Model type (either \emph{lm} or \emph{plm}; as string).}

\item{data}{Dataset.}
}
\value{
Returns tibble object, which includes delta*s over a range of maximum R-squares.
}
\description{
Estimates delta*s, i.e. the degree of selection on unobservables relative to observables (with respect to the treatment variable) that would be necessary to eliminate the result (following Oster 2019) over a range of maximum R-squares following Oster (2019).
}
\details{
Estimates delta*s, i.e. the degree of selection on unobservables relative to observables (with respect to the treatment variable) that would be necessary to eliminate the result (following Oster 2019) over a range of maximum R-squares. The range of maximum R-squares starts from the R-square of the controlled model rounded up to the next 1/100 to 1. The function supports linear cross sectional (see \emph{lm} objects in R) and fixed effect panel (see \emph{plm} objects in R) models.
}
\examples{
# load data, e.g. the in-build mtcars dataset
data("mtcars")
data_oster <- mtcars

# preview of data
head(data_oster)

# load robomit
require(robomit)

# estimate delta*s over a range of maximum R-squares
o_delta_rsq(y = "mpg",           # dependent variable
            x = "wt",            # independent treatment variable
            con = "hp + qsec",   # other control variables
            beta = 0,            # beta
            type = "lm",         # model type
            data = data_oster)   # dataset
}
\references{
Oster, E. (2019). Unobservable selection and coefficient stability: Theory and evidence. Journal of Business & Economic Statistics, 37, 187-204.
}
