% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{cov_control}
\alias{cov_control}
\title{Tuning parameters for Huber M-estimation of location and scatter}
\usage{
cov_control(prob = 0.95, max_iterations = 200, tol = 1e-07)
}
\arguments{
\item{prob}{numeric; probability for the quantile of the
\eqn{\chi^{2}}{chi-squared} distribution to be used as cutoff point in the
Huber weight function (defaults to 0.95).}

\item{max_iterations}{an integer giving the maximum number of iterations in
the iteratively reweighted algorithm.}

\item{tol}{a small positive numeric value to be used to determine
convergence of the iteratively reweighted algorithm.}
}
\value{
A list with components corresponding to the arguments.
}
\description{
Obtain a list with tuning paramters for \code{\link{cov_Huber}}.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
ctrl <- cov_control(prob = 0.95)
test <- test_mediation(BSG2014,
                       x = "ValueDiversity",
                       y = "TeamCommitment",
                       m = "TaskConflict",
                       method = "covariance",
                       control = ctrl)
summary(test)

}
\references{
Huber, P.J. (1981) \emph{Robust statistics}. John Wiley & Sons.
}
\seealso{
\code{\link{cov_Huber}}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
