% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnetcarto.R
\docType{package}
\name{rnetcarto}
\alias{rnetcarto}
\alias{netcarto}
\title{Computes modularity and modularity roles from a network.}
\usage{
netcarto(
  web,
  seed = as.integer(floor(runif(1, 1, 100000001))),
  iterfac = 1,
  coolingfac = 0.995,
  bipartite = FALSE
)
}
\arguments{
\item{web}{network either as a square adjacency matrix or a list
describing E interactions a->b: the first (resp. second) element is
the vector of the labels of a (resp. b), the third (optional) is
the vector of interaction weights.}

\item{seed}{Seed for the random number generator: Must be a
positive integer.}

\item{iterfac}{At each temperature of the simulated annealing
(SA), the program performs fN^2 individual-node updates (involving the
movement of a single node from one module to another) and fN
collective updates (involving the merging of two modules and the split
of a module). The number "f" is the iteration factor.}

\item{coolingfac}{Temperature cooling factor.}

\item{bipartite}{If True use the bipartite definition of modularity.}
}
\value{
A list. The first element is a dataframe with the name,
module, z-score, and participation coefficient for each row of the
input matrix. The second element is the modularity of this
partition.
}
\description{
Compute modularity and modularity roles for graphs using simulated
annealing
}
\examples{
# Generate a simple random network
a = matrix(as.integer(runif(100)<.3), ncol=10) 
a[lower.tri(a)] = 0
# Find an optimal partition for modularity using netcarto.
netcarto(a)

}
