% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_model_nested_sets.R
\name{rmw_model_nested_sets}
\alias{rmw_model_nested_sets}
\title{Function to train random forest models using a nested tibble.}
\usage{
rmw_model_nested_sets(
  df_nest,
  variables,
  n_trees = 10,
  mtry = NULL,
  min_node_size = 5,
  n_cores = NA,
  verbose = FALSE
)
}
\arguments{
\item{df_nest}{Nested tibble created by \code{\link{rmw_nest_for_modelling}}.}

\item{variables}{Independent/explanatory variables used to predict \code{"value"}.}

\item{n_trees}{Number of trees to grow to make up the forest.}

\item{mtry}{Number of variables to possibly split at in each node. Default is
the (rounded down) square root of the number variables.}

\item{min_node_size}{Minimal node size.}

\item{n_cores}{Number of CPU cores to use for the model calculations.}

\item{verbose}{Should the function give messages?}
}
\value{
Nested tibble.
}
\description{
Function to train random forest models using a nested tibble.
}
\seealso{
\code{\link{rmw_nest_for_modelling}}, 
\code{\link{rmw_predict_nested_sets}}, \code{\link{rmw_train_model}}
}
\author{
Stuart K. Grange
}
