% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmdcount.R
\name{rmdcount}
\alias{rmdcount}
\title{Word, character and non-whitespace characters count}
\usage{
rmdcount(files = NULL, space = "[[:space:]]", word = "[[:space:]]+")
}
\arguments{
\item{files}{character: file name(s)}

\item{space}{character: pattern to split a text at spaces (default: \code{'[[:space:]]'})}

\item{word}{character: pattern to split a text at word boundaries (default: \code{'[[:space:]]+'})}
}
\value{
a data frame wthe following elements
\describe{
\item{file}{basename of a file}
\item{words}{number of words including code chunks}
\item{chars}{number of characters including code chunks}
\item{nonws}{number of non-whitespace characters including code chunks}
\item{words_chunk}{number of words excluding code chunks}
\item{chars_chunk}{number of characters excluding code chunks}
\item{nonws_chunk}{number of non-whitespace characters excluding code chunks}
\item{path}{path of a file}
}
}
\description{
Counts words, characters and non-whitespace characters in R Markdown files.
}
\details{
It uses the following approaches to detect words, characters and non-whitespace characters. 

\describe{
\item{words}{\code{strsplit(rmd, word)[[1]]} with \code{word} equal to \code{'[[:space:]]+'}}
\item{characters}{\code{strsplit(rmd, '')[[1]]}}
\item{non-whitespace characters}{\code{strsplit(gsub(space, '', rmd), '')[[1]]} with \code{space} equal to \code{'[[:space:]]'}}
}

This is repeated for the text without code chunks. Code chunks are deleted with \code{gsub('```\\\{.*?```', '', rmd)}.
}
\examples{
files <- system.file('rmarkdown/rstudio_pdf.Rmd', package="rmdwc")
rmdcount(files)
# use of rmdcount() in a R Markdown document 
if (interactive()) {
  file.edit(files) # SAVE(!) the file and knit it 
}
}
