% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdcev.data.R
\name{mdcev.data}
\alias{mdcev.data}
\title{data.frame for mdcev model}
\usage{
mdcev.data(
  data,
  id.var = NULL,
  alt.var = NULL,
  choice = "choice",
  price = "price",
  income = "income",
  alt.levels = NULL,
  drop.index = FALSE,
  subset = NULL,
  ...
)
}
\arguments{
\item{data}{a `data.frame`,}

\item{id.var}{the name of the variable that contains the individual
index. Note that the id.var must be unique for each}

\item{alt.var}{the name of the variable that contains the
alternative index or the name under which the alternative index
will be stored (the default  name is `alt`),}

\item{choice}{the variable indicating the consumption of non-numeraire
alternatives that is made: it has to be a numerical vector. Default is "choice".}

\item{price}{the variable indicating the price of the non-numeraire
alternatives. Default is "price"}

\item{income}{the variable indicating the income of the individual.
Default is "income".}

\item{alt.levels}{the name of the alternatives: if null,
they are guessed from the `alt.var` argument,}

\item{drop.index}{should the index variables be dropped from the
`data.frame`,}

\item{subset}{a logical expression which defines the subset of
observations to be selected,}

\item{...}{further arguments.}
}
\value{
A `mdcev.data` object, which is a `data.frame` in long
    format, *i.e.* one line for each alternative.  It has a `index`
    attribute, which is a `data.frame` that contains the
    index of the individual (`id`) and the index of the alternative
    (`alt`).
}
\description{
shape a `data.frame` in a suitable form for the use of the
`mdcev` function and complete some data checks
}
