% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptation.R
\name{shape_adapter}
\alias{shape_adapter}
\title{Create object to adapt proposal shape.}
\usage{
shape_adapter(type = "covariance", kappa = 1)
}
\arguments{
\item{type}{Type of shape adapter to use. One of:
\itemize{
\item "variance": Diagonal shape matrix adaptation based on estimates of target
distribution variances (see \code{\link[=variance_shape_adapter]{variance_shape_adapter()}}),
\item "covariance": Dense shape matrix adaptation based on estimates of target
distribution covariance matrix (see \code{\link[=covariance_shape_adapter]{covariance_shape_adapter()}}).
}}

\item{kappa}{Decay rate exponent in \verb{[0.5, 1]} for adaptation learning rate.
Value of 1 (default) corresponds to computing empirical (co)variances.}
}
\value{
List of functions with entries
\itemize{
\item \code{initialize}, a function for initializing adapter state and proposal
parameters at beginning of chain,
\item \code{update} a function for updating adapter state and proposal parameters on
each chain iteration,
\item \code{finalize} a function for performing any final updates to adapter state and
proposal parameters on completion of chain sampling (may be \code{NULL} if
unused).
\item \code{state} a zero-argument function for accessing current values of adapter
state variables.
}
}
\description{
Create object to adapt proposal shape.
}
\examples{
proposal <- barker_proposal()
adapter <- shape_adapter()
adapter$initialize(proposal, chain_state(c(0, 0)))
}
\seealso{
\code{\link[=variance_shape_adapter]{variance_shape_adapter()}}, \code{\link[=covariance_shape_adapter]{covariance_shape_adapter()}}
}
