/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation;

import weka.classifiers.CostMatrix;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.TwoClassStats;
import weka.core.FastVector;
import weka.core.Matrix;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ConfusionMatrix
extends Matrix {
    private static final long serialVersionUID = -181789981401504090L;
    protected String[] m_ClassNames;

    public ConfusionMatrix(String[] classNames) {
        super(classNames.length, classNames.length);
        this.m_ClassNames = (String[])classNames.clone();
    }

    public ConfusionMatrix makeWeighted(CostMatrix costs) throws Exception {
        if (costs.size() != this.size()) {
            throw new Exception("Cost and confusion matrices must be the same size");
        }
        ConfusionMatrix weighted = new ConfusionMatrix(this.m_ClassNames);
        int row = 0;
        while (row < this.size()) {
            int col = 0;
            while (col < this.size()) {
                weighted.setElement(row, col, this.getElement(row, col) * costs.getElement(row, col));
                ++col;
            }
            ++row;
        }
        return weighted;
    }

    @Override
    public Object clone() {
        ConfusionMatrix m = (ConfusionMatrix)super.clone();
        m.m_ClassNames = (String[])this.m_ClassNames.clone();
        return m;
    }

    public int size() {
        return this.m_ClassNames.length;
    }

    public String className(int index) {
        return this.m_ClassNames[index];
    }

    public void addPrediction(NominalPrediction pred) throws Exception {
        if (pred.predicted() == NominalPrediction.MISSING_VALUE) {
            throw new Exception("No predicted value given.");
        }
        if (pred.actual() == NominalPrediction.MISSING_VALUE) {
            throw new Exception("No actual value given.");
        }
        this.addElement((int)pred.actual(), (int)pred.predicted(), pred.weight());
    }

    public void addPredictions(FastVector predictions) throws Exception {
        int i = 0;
        while (i < predictions.size()) {
            this.addPrediction((NominalPrediction)predictions.elementAt(i));
            ++i;
        }
    }

    public TwoClassStats getTwoClassStats(int classIndex) {
        double fp = 0.0;
        double tp = 0.0;
        double fn = 0.0;
        double tn = 0.0;
        int row = 0;
        while (row < this.size()) {
            int col = 0;
            while (col < this.size()) {
                if (row == classIndex) {
                    if (col == classIndex) {
                        tp += this.getElement(row, col);
                    } else {
                        fn += this.getElement(row, col);
                    }
                } else if (col == classIndex) {
                    fp += this.getElement(row, col);
                } else {
                    tn += this.getElement(row, col);
                }
                ++col;
            }
            ++row;
        }
        return new TwoClassStats(tp, fp, tn, fn);
    }

    public double correct() {
        double correct = 0.0;
        int i = 0;
        while (i < this.size()) {
            correct += this.getElement(i, i);
            ++i;
        }
        return correct;
    }

    public double incorrect() {
        double incorrect = 0.0;
        int row = 0;
        while (row < this.size()) {
            int col = 0;
            while (col < this.size()) {
                if (row != col) {
                    incorrect += this.getElement(row, col);
                }
                ++col;
            }
            ++row;
        }
        return incorrect;
    }

    public double total() {
        double total = 0.0;
        int row = 0;
        while (row < this.size()) {
            int col = 0;
            while (col < this.size()) {
                total += this.getElement(row, col);
                ++col;
            }
            ++row;
        }
        return total;
    }

    public double errorRate() {
        return this.incorrect() / this.total();
    }

    @Override
    public String toString() {
        return this.toString("=== Confusion Matrix ===\n");
    }

    public String toString(String title) {
        int j;
        StringBuffer text = new StringBuffer();
        char[] IDChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean fractional = false;
        double maxval = 0.0;
        int i = 0;
        while (i < this.size()) {
            j = 0;
            while (j < this.size()) {
                double current = this.getElement(i, j);
                if (current < 0.0) {
                    current *= -10.0;
                }
                if (current > maxval) {
                    maxval = current;
                }
                double fract = current - Math.rint(current);
                if (!fractional && Math.log(fract) / Math.log(10.0) >= -2.0) {
                    fractional = true;
                }
                ++j;
            }
            ++i;
        }
        int IDWidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 3 : 0)), (int)(Math.log(this.size()) / Math.log(IDChars.length)));
        text.append(title).append("\n");
        i = 0;
        while (i < this.size()) {
            if (fractional) {
                text.append(" ").append(ConfusionMatrix.num2ShortID(i, IDChars, IDWidth - 3)).append("   ");
            } else {
                text.append(" ").append(ConfusionMatrix.num2ShortID(i, IDChars, IDWidth));
            }
            ++i;
        }
        text.append("     actual class\n");
        i = 0;
        while (i < this.size()) {
            j = 0;
            while (j < this.size()) {
                text.append(" ").append(Utils.doubleToString(this.getElement(i, j), IDWidth, fractional ? 2 : 0));
                ++j;
            }
            text.append(" | ").append(ConfusionMatrix.num2ShortID(i, IDChars, IDWidth)).append(" = ").append(this.m_ClassNames[i]).append("\n");
            ++i;
        }
        return text.toString();
    }

    private static String num2ShortID(int num, char[] IDChars, int IDWidth) {
        char[] ID = new char[IDWidth];
        int i = IDWidth - 1;
        while (i >= 0) {
            ID[i] = IDChars[num % IDChars.length];
            if ((num = num / IDChars.length - 1) < 0) break;
            --i;
        }
        --i;
        while (i >= 0) {
            ID[i] = 32;
            --i;
        }
        return new String(ID);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }
}

