/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.sliq.AttributeList;
import dmLab.classifier.sliq.ClassList;
import dmLab.classifier.sliq.NominalHistogram;
import dmLab.classifier.sliq.SliqNode;
import dmLab.classifier.sliq.SliqParams;
import dmLab.classifier.sliq.SliqTree;
import dmLab.classifier.sliq.Tree.treePruning.mdlTreePruning.MdlTreePruning;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;

public final class SliqClassifier
extends Classifier {
    private AttributeList[] attributesLists;
    private ClassList classList;
    private int trainAttrNumber;
    private SliqTree sliqTree;
    private FArray trainArray;
    private SliqParams cfg;

    public SliqClassifier() {
        this.label = "sliq";
        this.params = new SliqParams();
        this.cfg = (SliqParams)this.params;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        void var1_1;
        void var2_2;
        this.params.save(path, name);
        FileWriter writer = new FileWriter(String.valueOf(path) + "//" + (String)var2_2 + ".tree");
        writer.write(this.toString());
        var1_1.close();
        return true;
    }

    @Override
    public final boolean add_RI(AttributesRI[] importances) {
        this.attrSet = new HashSet();
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = QualityMeasure.calcWAcc(this.predResult.confusionMatrix.getMatrix());
        this.sliqTree.addInfo(this.trainArray, this.sliqTree.root, experimentIndicators, importances[0], this.attrSet);
        int i = 0;
        while (i < importances.length) {
            importances[i].flushMeasures();
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final boolean train(FArray trainArray) {
        this.trainArray = trainArray;
        this.trainSetSize = trainArray.rowsNumber();
        var4_2 = trainArray;
        this.trainAttrNumber = var4_2.attributes.length;
        this.attributesLists = new AttributeList[this.trainAttrNumber];
        start = System.currentTimeMillis();
        this.classList = new ClassList(trainArray);
        decisionIndex = trainArray.getDecAttrIdx();
        j = 0;
        while (j < this.trainAttrNumber) {
            if (j != decisionIndex) {
                this.attributesLists[j] = new AttributeList(trainArray, j);
            }
            ++j;
        }
        this.sliqTree = new SliqTree(this.classList);
        this.sliqTree.setAttributesNumber(this.trainAttrNumber);
        this.classList.initializeClassNodesRefs(this.sliqTree);
        level = 0;
        this.classList.calcClassFrequencies$2f9c67c6();
        var4_4 = this.sliqTree;
        this.sliqTree.calcFreqClassGiniPurity((SliqNode)var4_4.root, this.classList);
        if (true) ** GOTO lbl142
        block1: do {
            var4_4 = this;
            var7_16 = 0;
            while (var7_16 < var4_4.trainAttrNumber) {
                if (var4_4.attributesLists[var7_16] != null) {
                    var4_4.attributesLists[var7_16].initSplitStatus();
                    var15_34 = var4_4.attributesLists[var7_16];
                    var14_30 = var4_4.sliqTree;
                    var13_27 = var4_4.classList;
                    var16_36 = var14_30.getLeafsSize();
                    if (var15_34.getAttrType()) {
                        var17_38 = 0;
                        while (var17_38 < var16_36) {
                            var6_8 = var14_30.getLeaf(var17_38);
                            if (!var6_8.getLeafIndicator()) {
                                var6_8.numericHistogram.init(var6_8.classFrequencies);
                            }
                            ++var17_38;
                        }
                    } else {
                        var17_38 = 0;
                        while (var17_38 < var16_36) {
                            var6_9 = var14_30.getLeaf(var17_38);
                            if (!var6_9.getLeafIndicator()) {
                                var6_9.nominalHistogram = new NominalHistogram((ClassList)var13_27, (AttributeList)var15_34);
                            }
                            ++var17_38;
                        }
                    }
                    var12_26 = var4_4.attributesLists[var7_16].getEventsNumber();
                    if (var4_4.attributesLists[var7_16].getAttrType()) {
                        var13_27 = var4_4;
                        var14_31 = var13_27.sliqTree.getLeafsSize();
                        var6_10 = 0;
                        while (var6_10 < var14_31) {
                            var15_34 = var13_27.sliqTree.getLeaf(var6_10);
                            if (!var15_34.getLeafIndicator()) {
                                var15_34.tmpInit();
                            }
                            ++var6_10;
                        }
                        var8_20 = 0;
                        while (var8_20 < var12_26) {
                            if (!var4_4.classList.getAttrValueLeafPurity(var4_4.attributesLists[var7_16], var8_20)) {
                                var10_23 = var4_4.attributesLists[var7_16].getAttrProxyIndex(var8_20);
                                var11_24 = var4_4.classList.getAttrValueLeaf(var4_4.attributesLists[var7_16], var8_20);
                                if (var11_24.tmpSplittingValueProxyIndexEval == -1) {
                                    var11_24.tmpSplittingValueProxyIndexEval = var10_23;
                                }
                                if (var11_24.tmpSplittingValueProxyIndexEval != var10_23) {
                                    var9_22 = var4_4.sliqTree.getGoodnessOfSplit(var11_24, true);
                                    if (v0 > var11_24.tmpGoodnessOfSplit) {
                                        var11_24.tmpGoodnessOfSplit = var9_22;
                                        var11_24.tmpSplittingValueProxyIndex = var11_24.tmpSplittingValueProxyIndexEval;
                                        var11_24.tmpSplittingValueProxyIndexEval = var10_23;
                                    }
                                }
                                var4_4.classList.updateToLEftAttrValueLeafNumHist(var4_4.attributesLists[var7_16], var8_20);
                            }
                            ++var8_20;
                        }
                        super.splitsUpdate(var4_4.attributesLists[var7_16], var7_16, true);
                    } else {
                        var8_20 = 0;
                        while (var8_20 < var12_26) {
                            if (var7_16 == 9 && var8_20 == 8083 && !var4_4.classList.getAttrValueLeafPurity(var4_4.attributesLists[var7_16], var8_20)) {
                                var4_4.classList.incRightAttrValueLeafNomHist(var4_4.attributesLists[var7_16], var8_20);
                            }
                            ++var8_20;
                        }
                        super.splitsUpdate(var4_4.attributesLists[var7_16], var7_16, false);
                    }
                }
                ++var7_16;
            }
            var13_27 = var4_4;
            var14_32 = var13_27.sliqTree.getLeafsSize();
            var6_11 = 0;
            while (var6_11 < var14_32) {
                var15_34 = var13_27.sliqTree.getLeaf(var6_11);
                if (var15_34.attrListSplittingAttrIndex != -1) {
                    var13_27.attributesLists[var15_34.attrListSplittingAttrIndex].setSplitStatus(true);
                }
                ++var6_11;
            }
            this.sliqTree.createLeafs(this.classList);
            var6_12 = trainArray;
            var4_4 = this;
            var9_21 = var4_4.sliqTree.getLeafsSize();
            var10_23 = 0;
            while (var10_23 < var4_4.trainAttrNumber) {
                if (var4_4.attributesLists[var10_23] != null && var4_4.attributesLists[var10_23].getSplitStatus()) {
                    var11_25 = var4_4.attributesLists[var10_23].getAllEventsNumber();
                    var12_26 = 0;
                    while (var12_26 < var11_25) {
                        var8_20 = var4_4.attributesLists[var10_23].getAllAttrClassIndex(var12_26);
                        var7_18 = var4_4.classList.getClassLeafRef(var8_20);
                        if (!var7_18.getLeafIndicator() && var7_18.attrListSplittingAttrIndex == var10_23) {
                            block38: {
                                var15_35 = var8_20;
                                var14_33 = var6_12;
                                var13_28 = var7_18;
                                var16_37 = var14_33.readValue(var13_28.getSplittingAttrIndex(), var15_35);
                                var17_39 = var13_28.getSplittingValues();
                                if (var13_28.getSplittingAttrType()) {
                                    v1 = var16_37 <= var17_39[0];
                                } else {
                                    var13_29 = 0;
                                    do {
                                        if (var16_37 != var17_39[var13_29]) continue;
                                        v1 = true;
                                        break block38;
                                    } while (++var13_29 < var17_39.length);
                                    v1 = false;
                                }
                            }
                            if (v1) {
                                var4_4.classList.setClassLeafRef(var8_20, (SliqNode)var7_18.left);
                            } else {
                                var4_4.classList.setClassLeafRef(var8_20, (SliqNode)var7_18.right);
                            }
                        }
                        ++var12_26;
                    }
                }
                ++var10_23;
            }
            var4_4.classList.calcClassFrequencies$2f9c67c6();
            var10_23 = 0;
            while (var10_23 < var9_21) {
                var7_19 = var4_4.sliqTree.getLeaf(var10_23);
                if (!var7_19.getLeafIndicator()) {
                    var4_4.sliqTree.calcFreqClassGiniPurity(var7_19, var4_4.classList);
                }
                ++var10_23;
            }
            ++level;
lbl142:
            // 2 sources

            var4_4 = this.sliqTree;
            var6_7 = var4_4.getLeafsSize();
            var7_16 = 0;
            while (var7_16 < var6_7) {
                if (!var4_4.getLeaf(var7_16).getLeafIndicator()) {
                    v2 = false;
                    continue block1;
                }
                ++var7_16;
            }
            v2 = true;
        } while (!v2 && level < this.cfg.maxLevel);
        stop = System.currentTimeMillis();
        this.learningTime = (float)(stop - start) / 1000.0f;
        this.sliqTree.setTreeBuildingTime(this.learningTime);
        if (this.cfg.mdlPruning) {
            start = System.currentTimeMillis();
            var4_4 = this;
            stop = new MdlTreePruning(var4_4.sliqTree);
            stop.treePrune();
            stop = System.currentTimeMillis();
            this.learningTime = (float)(stop - var2_5) / 1000.0f;
            this.sliqTree.setTreePruningTime(this.learningTime);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_2;
        long start = System.currentTimeMillis();
        this.predResult.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), testArray.getDecValuesStr());
        int testEventsNumber = testArray.rowsNumber();
        this.predResult.predictions = new Prediction[testEventsNumber];
        int decAttrIndex = testArray.getDecAttrIdx();
        int i = 0;
        while (i < testEventsNumber) {
            int n = i;
            FArray fArray = testArray;
            SliqClassifier sliqClassifier = this;
            float predictedDecision = sliqClassifier.sliqTree.classifyEvent(fArray, n);
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.predResult.confusionMatrix.add(realDecision, predictedDecision);
            String realClassName = testArray.dictionary.toString(realDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predResult.predictions[i] = new Prediction(realClassName, predictedClassName, null);
            ++i;
        }
        long stop = System.currentTimeMillis();
        this.testingTime = (float)(stop - var2_2) / 1000.0f;
        return true;
    }

    @Override
    public final boolean init() {
        return true;
    }

    @Override
    public final boolean finish() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### Sliq Classifier ### \n");
        tmp.append("label=" + this.label).append('\n');
        tmp.append(this.sliqTree.toString(this.trainArray, true));
        return var1_1.toString();
    }

    private void splitsUpdate(AttributeList attributeList, int splittingAttrIndex, boolean splittingAttrType) {
        int leafsNumber = this.sliqTree.getLeafsSize();
        if (splittingAttrType) {
            int leafIndex = 0;
            while (leafIndex < leafsNumber) {
                SliqNode node = this.sliqTree.getLeaf(leafIndex);
                if (!node.getLeafIndicator() && node.tmpGoodnessOfSplit > node.getGoodnessOfSplit()) {
                    node.setGoodnessOfSplit(node.tmpGoodnessOfSplit);
                    node.setSplittingAttrIndex(attributeList.getAttrIndex());
                    node.attrListSplittingAttrIndex = splittingAttrIndex;
                    node.setSplittingAttrType(splittingAttrType);
                    float[] fArray = new float[1];
                    float[] splittingValues = fArray;
                    fArray[0] = attributeList.getAttrProxyValue(node.tmpSplittingValueProxyIndex);
                    node.setSplittingValues(splittingValues);
                }
                ++leafIndex;
            }
            return;
        }
        int leafIndex = 0;
        while (leafIndex < leafsNumber) {
            SliqNode node = this.sliqTree.getLeaf(leafIndex);
            if (!node.getLeafIndicator()) {
                float[] splittingValues = this.sliqTree.findBestSubset(node, attributeList);
                if (node.tmpGoodnessOfSplit > node.getGoodnessOfSplit()) {
                    node.setGoodnessOfSplit(node.tmpGoodnessOfSplit);
                    node.setSplittingAttrIndex(attributeList.getAttrIndex());
                    node.attrListSplittingAttrIndex = splittingAttrIndex;
                    node.setSplittingAttrType(splittingAttrType);
                    node.setSplittingValues(splittingValues);
                }
            }
            ++leafIndex;
        }
    }
}

