/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Gamma;
import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class InvGamma
extends GenericDistribution {
    protected double shape;
    protected double scale;

    public static final double density(double x, double shape, double scale, boolean give_log) {
        return Gamma.density(1.0 / x, shape, scale, give_log);
    }

    public static final double cumulative(double x, double alph, double scale, boolean lower_tail, boolean log_p) {
        return Gamma.cumulative(1.0 / x, alph, scale, lower_tail, log_p);
    }

    public static final double quantile(double x, double alph, double scale, boolean lower_tail, boolean log_p) {
        return 1.0 / Gamma.quantile(x, alph, scale, lower_tail, log_p);
    }

    public static final double random(double alph, double scale, RandomEngine random) {
        return 1.0 / Gamma.random(alph, scale, random);
    }

    public static final double[] random(int n, double alph, double scale, RandomEngine random) {
        double[] rand = new double[n];
        int i = 0;
        while (i < n) {
            rand[i] = InvGamma.random(alph, scale, random);
            ++i;
        }
        return rand;
    }

    public InvGamma(double shape, double scale) {
        this.shape = shape;
        this.scale = scale;
    }

    public double density(double x, boolean log) {
        return InvGamma.density(x, this.shape, this.scale, log);
    }

    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return InvGamma.cumulative(p, this.shape, this.scale, lower_tail, log_p);
    }

    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return InvGamma.quantile(q, this.shape, this.scale, lower_tail, log_p);
    }

    public double random() {
        return InvGamma.random(this.shape, this.scale, this.random);
    }
}

