/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine.modules;

import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesID.AttributesID;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.mcfsEngine.modules.Split;
import dmLab.utils.ArrayUtils;
import dmLab.utils.cmatrix.AccuracyMeasure;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.statList.StatsList;
import dmLab.utils.statList.StatsObject;
import java.util.Arrays;
import java.util.Random;

public final class Projection {
    private MCFSParams mcfsParams;
    private Split split;
    private ConfusionMatrix confusionMatrix;
    private StatsList splitsStats;
    private DiscFunctions selectFunctions$49f14b5d;

    /*
     * WARNING - void declaration
     */
    public Projection(MCFSParams mcfsParams, Random random) {
        void var2_2;
        void var1_1;
        this.mcfsParams = mcfsParams;
        this.split = new Split((MCFSParams)var1_1, random);
        this.confusionMatrix = null;
        this.selectFunctions$49f14b5d = new DiscFunctions((Random)var2_2);
    }

    public final ConfusionMatrix projectionLoop(Classifier classifier, FArray inputArray, AttributesRI[] attrRI, AttributesID attrIDependencies) {
        this.splitsStats = new StatsList();
        this.splitsStats.addHeader$505d15af("acc,wAcc,errors");
        this.confusionMatrix = new ConfusionMatrix(inputArray.getColNames(true)[inputArray.getDecAttrIdx()], inputArray.getDecValuesStr());
        int projectionSize = this.mcfsParams.projectionSizeAttr;
        Object object = inputArray;
        if (projectionSize >= ((FArray)object).attributes.length) {
            object = inputArray;
            projectionSize = ((FArray)object).attributes.length - 1;
        }
        int[] colMask = this.selectFunctions$49f14b5d.getColumnsMask(inputArray, projectionSize);
        boolean[] blArray = new boolean[((Array)inputArray).rowsNumber()];
        object = blArray;
        Arrays.fill(blArray, true);
        FArray projectionArray = (FArray)((Array)inputArray).clone(ArrayUtils.int2boolean(colMask, 1), (boolean[])object);
        int i = 0;
        while (i < attrRI.length) {
            attrRI[i].addProjections(projectionArray);
            ++i;
        }
        if (this.mcfsParams.verbose) {
            System.out.println("projectionArray# " + projectionArray.info());
        }
        int j = 0;
        while (j < this.mcfsParams.splits) {
            if (this.mcfsParams.verbose) {
                System.out.println("*** SPLIT: " + j + " *** ");
            }
            FArray balancedArray = projectionArray;
            if (this.mcfsParams.balanceRatio > 0.0f) {
                if (this.mcfsParams.verbose) {
                    System.out.println("Balancing table...");
                }
                balancedArray = this.selectFunctions$49f14b5d.balanceClasses(projectionArray, this.mcfsParams.balanceRatio);
                if (this.mcfsParams.verbose) {
                    System.out.println("balancedArray# " + balancedArray.info());
                }
            }
            FArray limitedSizeArray = balancedArray;
            if (this.mcfsParams.splitSetSize > 0) {
                if (this.mcfsParams.verbose) {
                    System.out.println("Decreasing number of objects...");
                }
                limitedSizeArray = (FArray)this.selectFunctions$49f14b5d.selectRowsRandom(balancedArray, this.mcfsParams.splitSetSize);
                if (this.mcfsParams.verbose) {
                    System.out.println("limitedSizeArray# " + limitedSizeArray.info());
                }
            }
            ConfusionMatrix matrix = this.split.splitLoop(classifier, limitedSizeArray, attrRI, attrIDependencies);
            this.confusionMatrix.add(matrix);
            float[] stats = new float[]{(float)AccuracyMeasure.calcAcc(matrix.getMatrix()), (float)AccuracyMeasure.calcWAcc(matrix.getMatrix()), AccuracyMeasure.errors(matrix.getMatrix())};
            this.splitsStats.add(new StatsObject(stats));
            ++j;
        }
        return this.confusionMatrix;
    }

    public final StatsList getSplitsStats() {
        return this.splitsStats;
    }
}

