% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotplot.R
\name{plotClusterFactorDot}
\alias{plotClusterFactorDot}
\title{Make dot plot of factor loading in cell groups}
\usage{
plotClusterFactorDot(
  object,
  groupBy = NULL,
  useDims = NULL,
  useRaw = FALSE,
  splitBy = NULL,
  factorScaleFunc = NULL,
  cellIdx = NULL,
  legendColorTitle = "Mean Factor\\nLoading",
  legendSizeTitle = "Percent\\nLoaded",
  viridisOption = "viridis",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object}

\item{groupBy}{The names of the columns in \code{cellMeta} slot storing
categorical variables. Loading data would be aggregated basing on these,
together with \code{splitBy}. Default uses default clusters.}

\item{useDims}{A Numeric vector to specify exact factors of interests.
Default \code{NULL} uses all available factors.}

\item{useRaw}{Whether to use un-aligned cell factor loadings (\eqn{H}
matrices). Default \code{FALSE}.}

\item{splitBy}{The names of the columns in \code{cellMeta} slot storing
categorical variables. Dotplot panel splitting would be based on these.
Default \code{NULL}.}

\item{factorScaleFunc}{A function object applied to factor loading matrix for
scaling the value for better visualization. Default \code{NULL}.}

\item{cellIdx}{Valid cell subscription. See \code{\link{subsetLiger}}.
Default \code{NULL} for using all cells.}

\item{legendColorTitle}{Title for colorbar legend. Default
\code{"Mean Factor\nLoading"}.}

\item{legendSizeTitle}{Title for size legend. Default
\code{"Percent\nLoaded"}}

\item{viridisOption}{Name of available viridis palette. See
\code{\link[viridis]{viridis}}. Default \code{"viridis"}.}

\item{verbose}{Logical. Whether to show progress information. Mainly when
subsetting data. Default \code{FALSE}.}

\item{...}{Additional theme setting arguments passed to
\code{\link{.complexHeatmapDotPlot}} and heatmap setting arguments passed to
\code{\link[ComplexHeatmap]{Heatmap}}. See Details.}
}
\value{
\code{\link[ComplexHeatmap]{HeatmapList}} object.
}
\description{
This function produces dot plots. Each column represent a group
of cells specified by \code{groupBy}, each row is a factor specified by
\code{useDims}. The color of dots reflects mean of factor loading of
specified factors in each cell group and sizes reflects the percentage of
cells that have loadings of a factor in a group. We utilize
\href{https://jokergoo.github.io/ComplexHeatmap-reference/book/index.html}{ComplexHeatmap}
for simplified management of adding annotation and slicing subplots. This was
inspired by the implementation in
\href{https://samuel-marsh.github.io/scCustomize/reference/Clustered_DotPlot.html}{scCustomize}.
}
\details{
For \code{...}, please notice that arguments \code{colorMat},
\code{sizeMat}, \code{featureAnnDF}, \code{cellSplitVar}, \code{cellLabels}
and \code{viridisOption} from \code{\link{.complexHeatmapDotPlot}} are
already occupied by this function internally. A lot of arguments from
\code{\link[ComplexHeatmap]{Heatmap}} have also been occupied: \code{matrix,
name, heatmap_legend_param, rect_gp, col, layer_fun, km, border, border_gp,
column_gap, row_gap, cluster_row_slices, cluster_rows, row_title_gp,
row_names_gp, row_split, row_labels, cluster_column_slices, cluster_columns,
column_split, column_title_gp, column_title, column_labels, column_names_gp,
top_annotation}.
}
\examples{
plotClusterFactorDot(pbmcPlot)
}
