% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLT.R
\name{CLT}
\alias{CLT}
\title{The function explores numerical properties of statistical estimators operating on random processes.}
\usage{
CLT(Nmc, s, m, M, alpha, H, sigma, fr, Inference, ...)
}
\arguments{
\item{Nmc}{Number of Monte Carlo repetitions}

\item{s}{sequence of path lengths}

\item{m}{discretization. A number of points between two nearby motion points}

\item{M}{truncation parameter. A number of points at which the integral representing the definition of lfsm is calculated. So, after M points back we consider the rest of the integral to be 0.}

\item{alpha}{self-similarity parameter of alpha stable random motion.}

\item{H}{Hurst parameter}

\item{sigma}{Scale parameter of lfsm}

\item{fr}{frequency. Either "H" or "L"}

\item{Inference}{statistical function to apply to sample paths}

\item{...}{parameters to pass to Inference}
}
\value{
It returns a list containing the following components:
    \item{CLT_dataset}{a data frame, standardized values of the estimates depending on path length s}
    \item{BSdM}{a data frame, means, biases and standard deviations depending on s}
    \item{Inference}{a closure used to obtain estimates}
    \item{alpha, H, sigma}{the parameters for which CLT performs path generation}
    \item{freq}{frequency, either 'L'  for low- or 'H' for high frequency}
}
\description{
The function is useful, for instance, when one needs to compute standard deviation of \eqn{\widehat \alpha_{high}}
estimator given a fixed set of parameters.
}
\details{
CLT  performs Monte-Carlo experiments to compute parameters according to procedure Inference.
More specifically, for each element of s it generates Nmc lfsm sample paths with length equal to s[i], performs the statistical
inference on each, obtaining the estimates, and then returns their different statistics. It is vital that the estimator
returns a list of named parameters (one or several of 'sigma', 'alpha' and 'H'). CLT uses the names to lookup the true
parameter value and compute its bias.

For sample path generation CLT uses a light-weight version of path, path_fast. In order to be applied,
function Inference must accept argument 'path' as a sample path.
}
\examples{
#### Set of global parameters ####
m<-25; M<-60
p<-.4; p_prime<-.2; k<-2
t1<-1; t2<-2
NmonteC<-5e1
S<-c(1e2,3e2)
alpha<-1.8; H<-0.8; sigma<-0.3


# How to plot empirical density
\donttest{
theor_3_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,ContinEstim,
                     t1=t1,t2=t2,p=p,k=k)
l_plot<-Plot_dens(par_vec=c('sigma','alpha','H'),
                  CLT_data=theor_3_1_H_clt, Nnorm=1e7)

}

# For CLT() it is vital that the estimator returns a list of named parameters

H_hat_f <- function(p,k,path) {hh<-H_hat(p,k,path); list(H=hh)}
theor_3_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,H_hat_f,
                     p=p,k=k)


# The estimator can return one, two or three of the parameters.

est_1 <- function(path) list(H=1)
theor_3_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,est_1)

est_2 <- function(path) list(H=0.8, alpha=1.5)
theor_3_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,est_2)

est_3 <- function(path) list(sigma=5, H=0.8, alpha=1.5)
theor_3_1_H_clt<-CLT(s=S,fr='H',Nmc=NmonteC,
                     m=m,M=M,alpha=alpha,H=H,
                     sigma=sigma,est_3)
}
