% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Maximum-Matching-Algorithms}
\alias{Maximum-Matching-Algorithms}
\alias{MaximumWeightPerfectMatchingRunner}
\alias{MaximumWeightFractionalPerfectMatchingRunner}
\alias{MaximumWeightFractionalMatchingRunner}
\alias{MaximumWeightMatchingRunner}
\alias{MaximumCardinalityMatchingRunner}
\alias{MaximumCardinalityFractionalMatchingRunner}
\title{Maximum Matching Algorithms}
\usage{
MaximumWeightPerfectMatchingRunner(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes
)

MaximumWeightFractionalPerfectMatchingRunner(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes
)

MaximumWeightFractionalMatchingRunner(
  arcSources,
  arcTargets,
  arcWeights,
  numNodes
)

MaximumWeightMatchingRunner(arcSources, arcTargets, arcWeights, numNodes)

MaximumCardinalityMatchingRunner(arcSources, arcTargets, numNodes)

MaximumCardinalityFractionalMatchingRunner(arcSources, arcTargets, numNodes)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's edges}

\item{arcWeights}{Vector corresponding to the weights of a graph's edges}

\item{numNodes}{The number of nodes in the graph}
}
\value{
A list containing two entries: 1) The matching value, 2) The edges of the final graph, in a List of List of (node, node) pairs
}
\description{
`MaximumWeightPerfectMatchingRunner` solves the Maximum-Weight Perfect Matching Problem

`MaximumWeightFractionalPerfectMatchingRunner` solves the Maximum-Weight Fractional Perfect Matching Problem

`MaximumWeightFractionalMatchingRunner` solves the Maximum-Weight Fractional Matching Problem

`MaximumWeightMatchingRunner` solves the Maximum-Weight Matching Problem

`MaximumCardinalityMatchingRunner` solves the Maximum Cardinality Matching Problem

`MaximumCardinalityFractionalMatchingRunner` solves the Maximum-Cardinality Fractional Matching Problem
}
