% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{is_compiled}
\alias{is_compiled}
\title{Dummy function to check if \code{rkeops} is installed on the system}
\usage{
is_compiled()
}
\description{
This function is used in automatic tests and check fucntions where the
expected behavior is different depending if \code{rkeops} is installed or not
(e.g. in calls to \code{devtools::check()} vs \code{devtools::test()} respectively).
}
\details{
When running automatic tests without building and installing the package,
i.e. with \code{devtools::test()}, the package file structure is different
from the structure of a built and installed package (obtained with
\code{devtools::check()}). For instance, the directory \code{inst/include} is
replaced by \code{include}, or \code{src} by \code{lib}. Check functions inside \code{rkeops}
have different behavior between these two cases.

The function \code{is_compiled} is used, if available, by the function
\code{\link[=is_installed]{is_installed()}} to check the availability of \code{rkeops} package
installation files. If not, i.e. if \code{rkeops} is not installed, the
function \code{\link[=is_installed]{is_installed()}} can detect it.
}
\seealso{
\code{\link[=is_installed]{is_installed()}}
}
\author{
Ghislain Durif
}
\keyword{internal}
