% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectbraiding.R
\name{checkbraided}
\alias{checkbraided}
\title{Check for Braiding in a River Network}
\usage{
checkbraided(rivers, startseg = NULL, endseg = NULL, progress = TRUE)
}
\arguments{
\item{rivers}{The river network object to check.}

\item{startseg}{Starting segment of a route to investigate.  If this and
\code{endseg} are \code{NULL}, the full river network will be checked.}

\item{endseg}{Starting segment of a route to investigate.  If this and
\code{startseg} are \code{NULL}, the full river network will be checked.}

\item{progress}{Whether to show the progress bar.  Defaults to \code{TRUE}.}
}
\description{
Detects braiding (multiple flow channels between two locations)
  within a river network object.  Braiding can either be checked for in the
  route between two segments, or in the river network as a whole.
}
\note{
This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(Gulk)
plot(x=Gulk)
checkbraided(rivers=Gulk)

data(KilleyW)
plot(x=KilleyW)
checkbraided(rivers=KilleyW)

Kenai3.subset <- trimriver(trimto=c(22,2,70,30,15,98,96,89,52,3), rivers=Kenai3)
plot(x=Kenai3.subset)

checkbraided(startseg=1, endseg=7, rivers=Kenai3.subset)
checkbraided(startseg=1, endseg=5, rivers=Kenai3.subset)
}
\author{
Matt Tyers
}

