% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accepted_names.R
\name{accepted_names}
\alias{accepted_names}
\title{Get accepted names from tsn}
\usage{
accepted_names(tsn, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
Zero row data.frame if the name is accepted, otherwise a data.frame
with information on the currently accepted name
}
\description{
Get accepted names from tsn
}
\examples{
\dontrun{
# TSN accepted - good name
accepted_names(tsn = 208527)

# TSN not accepted - input TSN is old name
accepted_names(tsn = 504239)

# raw json
accepted_names(tsn = 208527, raw = TRUE)
}
}

