% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{dec.err}
\alias{dec.err}
\title{Number of individuals for which the decision is erroneous.}
\format{An object of class \code{numeric} of length 1.}
\usage{
dec.err
}
\description{
\code{dec.err} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the decision is incorrect or erroneous (i.e., cases in which the
decision does not correspond to the condition).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{dec.err} individuals depends on the population size \code{\link{N}} and
is equal to the sum of false negatives \code{\link{mi}} and false positives \code{\link{fa}}.

\item to other frequencies:
In a population of size \code{\link{N}} the following relationships hold:

\itemize{

\item \code{\link{N}  =  \link{cond.true} + \link{cond.false}} (by condition)

\item \code{\link{N}  =  \link{dec.pos} + \link{dec.neg}} (by decision)

\item \code{\link{N} = \link{dec.cor} + \link{dec.err}} (by correspondence of decision to condition)

\item \code{\link{dec.cor} = \link{hi} + \link{cr}}

\item \code{\link{dec.err} = \link{mi} + \link{fa}}

\item \code{\link{N}  =  \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }

}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
dec.err <- 1000 * .50   # => sets dec.err to 50\% of 1000 = 500 cases.
is_freq(dec.err)        # => TRUE
is_prob(dec.err)        # => FALSE, as dec.err is no probability (but acc, bacc/wacc ARE)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: \code{\link{N}},
  \code{\link{cond.false}}, \code{\link{cond.true}},
  \code{\link{cr}}, \code{\link{dec.cor}},
  \code{\link{dec.neg}}, \code{\link{dec.pos}},
  \code{\link{fa}}, \code{\link{hi}}, \code{\link{mi}}
}
\keyword{datasets}
