% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/characterize.R
\name{characterize}
\alias{characterize}
\alias{factorize}
\alias{characterize.default}
\alias{characterize.data.frame}
\alias{factorize.default}
\alias{factorize.data.frame}
\title{Character conversion of labelled data}
\usage{
characterize(x, ...)

factorize(x, ...)

\method{characterize}{default}(x, ...)

\method{characterize}{data.frame}(x, ...)

\method{factorize}{default}(x, coerce_character = FALSE, ...)

\method{factorize}{data.frame}(x, ...)
}
\arguments{
\item{x}{A vector or data frame.}

\item{\dots}{additional arguments passed to methods}

\item{coerce_character}{A logical indicating whether to additionally coerce character columns to factor (in \code{factorize}). Default \code{FALSE}.}
}
\description{
Convert labelled variables to character or factor
}
\details{
\code{characterize} converts a vector with a \code{labels} attribute of named levels into a character vector. \code{factorize} does the same but to factors. This can be useful at two stages of a data workflow: (1) importing labelled data from metadata-rich file formats (e.g., Stata or SPSS), and (2) exporting such data to plain text files (e.g., CSV) in a way that preserves information.
}
\examples{
# vector method
x <- structure(1:4, labels = c("A" = 1, "B" = 2, "C" = 3))
characterize(x)
factorize(x)

# data frame method
x <- data.frame(v1 = structure(1:4, labels = c("A" = 1, "B" = 2, "C" = 3)),
                v2 = structure(c(1,0,0,1), labels = c("foo" = 0, "bar" = 1)))
str(factorize(x))
str(characterize(x))

# comparison of exported file contents
import(export(x, csv_file <- tempfile(fileext = ".csv")))
import(export(factorize(x), csv_file))

# cleanup
unlink(csv_file)

}
\seealso{
\code{\link{gather_attrs}}
}
