% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{rim-package}
\alias{rim}
\alias{rim-package}
\alias{maxima.start}
\alias{maxima.stop}
\alias{maxima.get}
\alias{maxima.load}
\alias{maxima.apropos}
\alias{maxima.version}
\alias{maxima.isInstalled}
\alias{iprint}
\alias{print.maxima}
\title{rim}
\usage{
maxima.start(restart = FALSE)

maxima.stop()

maxima.get(command)

maxima.load(module)

maxima.apropos(keystring)

maxima.version()

maxima.isInstalled()

iprint(x)

\method{print}{maxima}(x, ...)
}
\arguments{
\item{restart}{if FALSE (default), then Maxima is started provided it is not running already. If TRUE starts or restarts Maxima.}

\item{command}{character string containing the Maxima command.}

\item{module}{character vector naming the Maxima module (typically a *.mac or *.lisp file) to be loaded.}

\item{keystring}{character vector containing a search term.}

\item{x}{S3 object of class "maxima"}

\item{...}{other arguments (ignored).}
}
\value{
invisibly returns NULL.

Character vector of length 1 of the input command. Depending on whether option "label" is set to TRUE, the corresponding input reference label is printed preceding the input command.
}
\description{
Provides an interface to Maxima, a computer algebra system.
}
\details{
Note: You need to install the Maxima software separately in order to make use of this package. 

Maxima is set up automatically on attachment via \code{library(rim)} and automatically started when a command is send (if it isn't running already) using \code{\link{maxima.get}()}. Using \code{\link{maxima.start}()} and \code{\link{maxima.stop}()}, one can stop and (re-)start the current Maxima session if needed, e.g. to clear Maxima command and output history.

To send a single command to Maxima and receive the corresponding output use \code{\link{maxima.get}()}. This function returns a S3 object of class "maxima". The output is printed by printing the object and will be printed in a format currently set by \code{\link{maxima.options}(format)}. The output format can be changed by setting it, e.g. \code{\link{maxima.options}(format = "ascii")}. Output labels are printed according to option \code{\link{maxima.options}(label)}.
}
\section{Functions}{
\itemize{
\item \code{maxima.start}: (re-)starts Maxima.

\item \code{maxima.stop}: Quits Maxima.

\item \code{maxima.get}: Executes a single Maxima command provided by \code{command}. If no command ending character (\code{;} or \code{$} is provided, \code{;} is appended.

\item \code{maxima.load}: A wrapper to load a Maxima module named by \code{module}

\item \code{maxima.apropos}: A wrapper to the Maxima helper function \code{apropos} to lookup existing Maxima functions that match \code{keystring}.

\item \code{maxima.version}: Returns the version number of Maxima that is used

\item \code{maxima.isInstalled}: Returns TRUE when an installation of Maxima has been detected, otherwise FALSE

\item \code{iprint}: Prints the input command of an maxima S3-object returned by \code{\link{maxima.get}()}

\item \code{print.maxima}: Prints the maxima output part of an S3 object returned by \code{\link{maxima.get}()}
}}

\seealso{
Useful links:
\itemize{
  \item \url{https://rcst.github.io/rim/}
  \item Report bugs at \url{https://github.com/rcst/rim/issues}
}


\code{\link{maxima.engine}}, \code{\link{maxima.options}}
}
\author{
\strong{Maintainer}: Eric Stemmler \email{stemmler.eric@gmail.com}

Authors:
\itemize{
  \item Kseniia Shumelchyk \email{shumelchyk@gmail.com}
  \item Hans W. Borchers \email{hwborchers@googlemail.com}
}

}
