% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/federation_facet.R
\name{federation_facet}
\alias{federation_facet}
\title{Federation facets}
\usage{
federation_facet(id, query = NULL, strict = FALSE, subclassQuery = NULL,
  expandSynonyms = TRUE, expandAcronyms = FALSE, expandAbbrevs = FALSE,
  expandInferred = TRUE, offset = 0, count = 20, minCount = 2,
  facet = NULL, filter = NULL, orMultiFacets = FALSE,
  subclassFilters = NULL, key = NULL, ...)
}
\arguments{
\item{id}{(character) A dataset id}

\item{query}{Query terms}

\item{strict}{(logical) Only consider more relevant columns.
Default: \code{FALSE}}

\item{subclassQuery}{(character) An known ID to query with subclass axiom
entailment (include all subclasses in the search). This can be combined
with the "query" parameter.}

\item{expandSynonyms}{(logical) Should recognized terms in the query have
synonyms expanded? Default: \code{TRUE}}

\item{expandAcronyms}{(logical) Default: \code{FALSE}}

\item{expandAbbrevs}{(logical) Default: \code{FALSE}}

\item{expandInferred}{(logical) Should recognized terms in the query have
inferred terms expanded? Default: \code{TRUE}}

\item{offset}{(integer) The result (row) to start on    query    0}

\item{count}{(integer) The number of results (rows) to return. Default: 20}

\item{minCount}{(integer) The minimum count result to return. Default: 2}

\item{facet}{(character) Facets specified like facetName:facetValue    query}

\item{filter}{(character) Filters specified like columnName:filterValue. If
the column is declared numeric then the filterValue can be a range
expression (ie: >24.3)}

\item{orMultiFacets}{(logical) True if multiple facet values for the same
facet are specified in the query and should be ORed together. Defaults
to "AND"}

\item{subclassFilters}{(character) Filter specified like
columnName:parentId where parentId is a known ID. All subclasses of
parentID will be included in the filter. This parameter may be
combined with "filter".}

\item{key}{(character) API key. required either passed in here or save
as an env var or R option. see \code{\link{rif}} and \code{\link{Startup}}}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\description{
Federation facets
}
\examples{
\dontrun{
out <- federation_facet(id = "nlx_152871-2")
out$category
out$facets

out <- federation_facet(id = "nlx_152871-2", count = 100)
out$category
out$facets

federation_facet(id = "nlx_152871-2", count = 100, minCount = 10)
}
}
\seealso{
Other federation: \code{\link{federation_data}},
  \code{\link{federation_search}}
}
