% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescales.R
\name{C14toDelta14C}
\alias{C14toDelta14C}
\title{Transform C14 age(s) into Delta14C}
\usage{
C14toDelta14C(y, er = NULL, t, roundby = Inf, lambda = 5730/log(2))
}
\arguments{
\item{y}{The C14 age to translate}

\item{er}{Reported error of the C14 age. Returns just the mean if left empty.}

\item{t}{the cal BP age}

\item{roundby}{Amount of decimals required for the output. Defaults to \code{roundby=Inf}, no rounding.}

\item{lambda}{Radiocarbon's mean-life, based on the Cambridge half-life}
}
\value{
The corresponding Delta14C value
}
\description{
Transform C14 age(s) into Delta14C
}
\details{
As explained by Heaton et al. 2020 (Radiocarbon), 14C measurements are commonly expressed in
three domains: Delta14C, F14C and the radiocarbon age. This function translates C14 ages into Delta14C, the historical level of Delta14C in the year t cal BP. Note that per convention, this function uses the Cambridge half-life, not the Libby half-life.
}
\examples{
  C14toDelta14C(0.985, 20, 222)
}
