% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_survprob.R
\name{cal_surv_prob}
\alias{cal_surv_prob}
\title{Calculate the survival probability from a fitted riAFT-BART model}
\usage{
cal_surv_prob(
  object,
  time.points,
  test.only = FALSE,
  train.only = FALSE,
  cluster.id
)
}
\arguments{
\item{object}{A fitted object from riAFTBART_estimate() function.}

\item{time.points}{A numeric vector representing the points at which the survival probability is computed.}

\item{test.only}{A logical indicating whether or not only data from the test set should be computed. The default is FALSE.}

\item{train.only}{A logical indicating whether or not only data from the training set should be computed. The default is FALSE.}

\item{cluster.id}{A vector of integers representing the cluster id. The cluster id should be an integer and start from 1.}
}
\value{
A list with the following two components
\item{Surv:}{A matrix of survival probabilities for each individual.}
\item{time.points:}{The time point entered.}
}
\description{
This function calculates the individual survival probability from a fitted riAFT-BART model at desired values of times
}
\examples{
\donttest{
library(riAFTBART)
set.seed(20181223)
n = 50      # number of clusters
k = 50      # cluster size
N = n*k     # total sample size
cluster.id = rep(1:n, each=k)
tau.error = 0.8
b = stats::rnorm(n, 0, tau.error)
alpha = 2
beta1 = 1
beta2 = -1
sig.error = 0.5
censoring.rate = 0.02
x1 = stats::rnorm(N,0.5,1)
x2 = stats::rnorm(N,1.5,0.5)
trt.train = sample(c(1,2,3), N, prob = c(0.4,0.3,0.2), replace = TRUE)
trt.test = sample(c(1,2,3), N, prob = c(0.3,0.4,0.2), replace = TRUE)
error = stats::rnorm(N,0,sig.error)
logtime = alpha + beta1*x1 + beta2*x2 + b[cluster.id] + error
y = exp(logtime)
C = rexp(N, rate=censoring.rate) # censoring times
Y = pmin(y,C)
status = as.numeric(y<=C)
res <- riAFTBART_fit(M.burnin = 50, M.keep = 50, M.thin = 1, status = status,
                      y.train = Y, trt.train = trt.train, trt.test = trt.test,
                      x.train = cbind(x1,x2),
                      x.test = cbind(x1,x2),
                      cluster.id = cluster.id)

surv_prob_res <- cal_surv_prob(object = res, time.points = sort(exp(logtime)),
test.only = TRUE, cluster.id = cluster.id)
}
}
