% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhubv2.R
\name{rhubv2}
\alias{rhubv2}
\title{R-hub v2}
\description{
Start here to learn about R-hub v2, especially if you
used the previous version of R-hub before.
}
\section{R-hub v2}{
\subsection{Introduction}{

R-hub v2, i.e. version 2 or later of the rhub package is a completely
new check system. In this acticle we highlight the differences between
the old and the new system.

There are two ways to use R-hub v2. The recommended way is to store your
R package in a GitHub repository and use the \verb{rhub_*()} functions to
start checks on GitHub Actions, using your own GitHub account.

Alternatively, if you don't want to store your R package at GitHub, you
can use the \verb{rc_*()} functions to run checks in a shared GitHub
organization at https://github.com/r-hub2, using the R Consortium runners.
See more about the R Consortium runners below.
}

\subsection{Transitioning from R-hub v1}{
\subsection{Requirements for using R-hub v2}{
\itemize{
\item First, you need a GitHub account.
\item Second, you need to have your R package in a GitHub repository.
In your local git clone make sure that the \code{origin} git remote is set
to the GitHub repository.
\item Third, you need a GitHub \href{https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token}{Personal Access Token}
and you need to store it in the git credential store on your machine.
You can use \code{gitcreds::gitcreds_set()} to add the token to the git
credential store.
}

Call \code{rhub_setup()} from the local git clone to set up R-hub v2 for your
package. This adds a GitHub Actions workflow to your local repository.
Push this change to GitHub, into your default git branch and then you
are ready to call start checks with \code{rhub_check()}.
}

\subsection{Differences from R-hub v1}{
\itemize{
\item The check picks up the package from GitHub, so it does not use
changes in your local git clone. You need to push the changes to
GitHub first. You can use a non-default branch, with the \code{branch}
argument of \code{rhub_check()}.
\item You'll not get an email about the check results. But you'll receive
regular GitHub notifications about check failures, unless you opt out.
Github can also turn these into emails if you like.
\item There is no live output from the check at the R console. See the
'Actions' tab of your repository on GitHub for a live check log.
\item Many more specialized platforms are available.
\item Most platforms use binary packages, so checks and in particular
installing dependencies is much faster.
}
}

\subsection{Private repositories}{

GitHub Actions is free for public repositories.
For private repositories you also get some minutes for free, depending on
the GitHub subscription you have. See
\href{https://docs.github.com/en/billing/managing-billing-for-github-actions/about-billing-for-github-actions}{About billing for GitHub Actions}
for details.
}

\subsection{Branches}{

You can run checks on any branch that you push to GitHub, but you'll need
to add the R-hub workflow file (\code{.github/workflows/rhub.yaml} within
your repo) must be present in \strong{both} the default branch (usually \code{main})
and also in the branch you want to run the check on.
}

}

\subsection{The R Consortium runners}{

If you don't want to put your package on GitHub, you can still use the
rhub package to run package checks on any supported platform using a
shared pool of runners in the https://github.com/r-hub2 GitHub
organization.

The process is similar to the first version of R-hub:
\itemize{
\item Set your working directory to the R package you want to check.
\item Obtain a token from R-hub, to verify your email address:

\if{html}{\out{<div class="sourceCode">}}\preformatted{rc_new_token()
}\if{html}{\out{</div>}}

(You do not need to do this, if you already submitted packages to a
previous version of R-hub from the same machine, using the same email
address. Call \code{rc_list_local_tokens()} to check if you already have
tokens.)
\item Submit a build with

\if{html}{\out{<div class="sourceCode">}}\preformatted{rc_submit()
}\if{html}{\out{</div>}}
\item Select the platforms you want to use, and follow the instructions and
the link provided to see your check results.
}
\subsection{Limitations of the R Consortium runners}{
\itemize{
\item You package will be public for the world, and will be stored in the
https://github.com/r-hub2 organization. Your check output and results
will be public for anyone with a GitHub account. If you want to keep
your package private, you can put it in a private GitHub repository,
and use the \code{rhub_setup()} and \code{rhub_check()} functions instead.
\item The R Consortium runners are shared among all users, so you might need
to wait for your builds to start.
\item You have to wait at least five minutes between submissions with
\code{rc_submit()}.
\item Currently you need to create a GitHub account to see the check logs of
your package. You don't need a GitHub account to submit the checks.
}

To avoid these limitations (except for the neeed for a GitHub accounr),
put your package in a GitHub repository, and use the \code{rhub_setup()} and
\code{rhub_check()} functions instead of \code{rc_submit()} and the R Consortium
runners.
}

}
}

