% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointDTM100_download.R
\name{pointDTM100_download}
\alias{pointDTM100_download}
\title{Download digital terrain models for voivodeships (100 m resolution)}
\usage{
pointDTM100_download(voivodeships, outdir = ".", unzip = TRUE, ...)
}
\arguments{
\item{voivodeships}{selected voivodeships in Polish or English, or TERC
(function \code{\link[=voivodeship_names]{voivodeship_names()}} can by helpful)}

\item{outdir}{(optional) name of the output directory;
by default, files are saved in the working directory}

\item{unzip}{TRUE (default) or FALSE, when TRUE the downloaded archive will
be extracted and removed}

\item{...}{additional argument for \code{\link[utils:download.file]{utils::download.file()}}}
}
\value{
text files with X, Y, Z columns (EPSG:2180)
}
\description{
Download digital terrain models for voivodeships (100 m resolution)
}
\examples{
\dontrun{
pointDTM100_download(c("opolskie", "świętokrzyskie")) # 8.5 MB
pointDTM100_download(c("Opole", "Swietokrzyskie")) # 8.5 MB
pointDTM100_download(c("16", "26")) # 8.5 MB
}
}
